/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.fx.behaviors.FXFocusBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXFocusFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXDefaultFocusFeedbackPartFactory
implements IFeedbackPartFactory<Node> {
    public static final String FOCUS_FEEDBACK_COLOR_PROVIDER = "FOCUS_FEEDBACK_COLOR_PROVIDER";
    public static final Color DEFAULT_FOCUS_FEEDBACK_COLOR = Color.web((String)"#8ec0fc");
    public static final String FOCUS_FEEDBACK_GEOMETRY_PROVIDER = "FOCUS_FEEDBACK_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    public List<IFeedbackPart<Node, ? extends Node>> createFeedbackParts(List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        if (!(contextBehavior instanceof FXFocusBehavior)) {
            throw new IllegalArgumentException("The FXDefaultFocusFeedbackPartFactory can only generate feedback parts in the context of an FXFocusBehavior, but the context behavior is a <" + contextBehavior + ">.");
        }
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        if (targets.size() > 1) {
            throw new IllegalArgumentException("Cannot create feedback for multiple targets.");
        }
        final IVisualPart<Node, ? extends Node> target = targets.iterator().next();
        ArrayList<IFeedbackPart<Node, ? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<Node, ? extends Node>>();
        final Provider focusFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)FOCUS_FEEDBACK_GEOMETRY_PROVIDER));
        if (focusFeedbackGeometryProvider != null) {
            Provider<IGeometry> geometryInSceneProvider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return NodeUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)focusFeedbackGeometryProvider.get()));
                }
            };
            FXFocusFeedbackPart part = (FXFocusFeedbackPart)((Object)this.injector.getInstance(FXFocusFeedbackPart.class));
            part.setGeometryProvider((Provider<? extends IGeometry>)geometryInSceneProvider);
            feedbackParts.add((IFeedbackPart<Node, ? extends Node>)part);
        }
        return feedbackParts;
    }
}

