/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;

public class FXBendConnectionOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final Connection connection;
    private final List<IAnchor> initialAnchors;
    private final List<IAnchor> newAnchors;

    public FXBendConnectionOperation(Connection connection) {
        super("Bend");
        this.connection = connection;
        this.initialAnchors = new ArrayList<IAnchor>(this.onlyExplicit((List<IAnchor>)connection.getAnchorsUnmodifiable()));
        this.newAnchors = new ArrayList<IAnchor>(this.initialAnchors);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.connection != null && !this.onlyExplicit((List<IAnchor>)this.connection.getAnchorsUnmodifiable()).equals(this.newAnchors)) {
            this.connection.setAnchors(this.newAnchors);
        }
        return Status.OK_STATUS;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getConnectionIndex(int explicitAnchorIndex) {
        int explicitCount = -1;
        int i = 0;
        while (i < this.getConnection().getAnchorsUnmodifiable().size()) {
            IAnchor a = this.getConnection().getAnchor(i);
            if (!this.getConnection().getRouter().wasInserted(a)) {
                ++explicitCount;
            }
            if (explicitCount == explicitAnchorIndex) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Cannot determine connection index for operation index " + explicitAnchorIndex + ".");
    }

    public List<IAnchor> getInitialAnchors() {
        return this.initialAnchors;
    }

    public List<IAnchor> getNewAnchors() {
        return this.newAnchors;
    }

    public boolean isContentRelevant() {
        return true;
    }

    public boolean isNoOp() {
        return this.initialAnchors.equals(this.newAnchors);
    }

    private List<IAnchor> onlyExplicit(List<IAnchor> anchors) {
        ArrayList<IAnchor> explicit = new ArrayList<IAnchor>(anchors);
        Iterator<IAnchor> it = explicit.iterator();
        while (it.hasNext()) {
            IAnchor anchor = it.next();
            if (!this.connection.getRouter().wasInserted(anchor)) continue;
            it.remove();
        }
        return explicit;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setNewAnchors(List<IAnchor> newAnchors) {
        this.newAnchors.clear();
        this.newAnchors.addAll(this.onlyExplicit(newAnchors));
    }

    public String toString() {
        return "FXBendConnectionOperation";
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.connection != null && !this.onlyExplicit((List<IAnchor>)this.connection.getAnchorsUnmodifiable()).equals(this.initialAnchors)) {
            this.connection.setAnchors(this.initialAnchors);
        }
        return Status.OK_STATUS;
    }
}

