/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricModel;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXGeometricModelPart
extends AbstractFXContentPart<Group> {
    private final ChangeListener<? super Boolean> snapToGridObserver = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            FXGeometricModelPart.this.applySnapToGrid(newValue);
        }
    };

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().add(index, (Object)((Node)child.getVisual()));
    }

    protected void applySnapToGrid(boolean snapToGrid) {
        ((GridModel)this.getViewer().getAdapter(GridModel.class)).setSnapToGrid(snapToGrid);
    }

    protected Group createVisual() {
        Group visual = new Group();
        visual.setAutoSizeChildren(false);
        return visual;
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().snapToGridProperty().addListener(this.snapToGridObserver);
    }

    protected void doAddContentChild(Object contentChild, int index) {
        if (!(contentChild instanceof AbstractFXGeometricElement)) {
            throw new IllegalArgumentException("Cannot add content child: wrong type!");
        }
        this.getContent().getShapeVisuals().add(index, (AbstractFXGeometricElement)contentChild);
    }

    protected void doDeactivate() {
        this.getContent().snapToGridProperty().removeListener(this.snapToGridObserver);
        super.doDeactivate();
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        ArrayList<AbstractFXGeometricElement<? extends IGeometry>> objs = new ArrayList<AbstractFXGeometricElement<? extends IGeometry>>();
        objs.addAll(this.getContent().getShapeVisuals());
        return objs;
    }

    protected void doRefreshVisual(Group visual) {
        this.applySnapToGrid(this.getContent().isSnapToGrid());
    }

    protected void doRemoveContentChild(Object contentChild) {
        this.getContent().getShapeVisuals().remove(contentChild);
    }

    public FXGeometricModel getContent() {
        return (FXGeometricModel)super.getContent();
    }

    public boolean isFocusable() {
        return false;
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().remove(child.getVisual());
    }
}

