/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.model;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;

public abstract class AbstractFXGeometricElement<G extends IGeometry> {
    public static final String GEOMETRY_PROPERTY = "geometry";
    public static final String TRANSFORM_PROPERTY = "transform";
    public static final String STROKE_WIDTH_PROPERTY = "strokeWidth";
    private final ObjectProperty<G> geometryProperty = new SimpleObjectProperty((Object)this, "geometry");
    private final ObjectProperty<AffineTransform> transformProperty = new SimpleObjectProperty((Object)this, "transform");
    private Paint stroke = new Color(0.0, 0.0, 0.0, 1.0);
    private Effect effect;
    private final DoubleProperty strokeWidthProperty = new SimpleDoubleProperty((Object)this, "strokeWidth", 0.5);

    public AbstractFXGeometricElement(G geometry) {
        this.setGeometry(geometry);
    }

    public AbstractFXGeometricElement(G geometry, AffineTransform transform, Paint stroke, double strokeWidth, Effect effect) {
        this(geometry);
        this.setTransform(transform);
        this.setEffect(effect);
        this.setStroke(stroke);
        this.setStrokeWidth(strokeWidth);
    }

    public AbstractFXGeometricElement(G geometry, Paint stroke, double strokeWidth, Effect effect) {
        this.setGeometry(geometry);
        this.setEffect(effect);
        this.setStroke(stroke);
        this.setStrokeWidth(strokeWidth);
    }

    public Effect getEffect() {
        return this.effect;
    }

    public G getGeometry() {
        return (G)((IGeometry)this.geometryProperty.get());
    }

    public Paint getStroke() {
        return this.stroke;
    }

    public double getStrokeWidth() {
        return this.strokeWidthProperty.get();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transformProperty.get();
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void setGeometry(G geometry) {
        this.geometryProperty.set(geometry);
    }

    public void setStroke(Paint stroke) {
        this.stroke = stroke;
    }

    public void setStrokeWidth(double strokeWidth) {
        this.strokeWidthProperty.set(strokeWidth);
    }

    public void setTransform(AffineTransform transform) {
        this.transformProperty.set((Object)transform);
    }
}

