/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.binding;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.beans.binding.SetMultimapExpression;
import org.eclipse.gef4.common.beans.binding.SetMultimapExpressionHelper;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.common.collections.SetMultimapChangeListener;

public abstract class SetMultimapBinding<K, V>
extends SetMultimapExpression<K, V>
implements Binding<ObservableSetMultimap<K, V>> {
    private SetMultimapExpressionHelper<K, V> helper = null;
    private SetMultimapChangeListener<K, V> invalidatingValueObserver = new SetMultimapChangeListener<K, V>(){

        @Override
        public void onChanged(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
            SetMultimapBinding.this.invalidateProperties();
            SetMultimapBinding.this.invalidated();
            SetMultimapBinding.this.fireValueChangedEvent(change);
        }
    };
    private ObservableSetMultimap<K, V> value = null;
    private InvalidationListener invalidatingDependenciesObserver = new InvalidationListener(){

        public void invalidated(Observable observable) {
            SetMultimapBinding.this.invalidate();
        }
    };
    private ObservableList<Observable> dependencies = null;
    private boolean valid = false;
    private EmptyProperty emptyProperty = null;
    private SizeProperty sizeProperty = null;

    public void addListener(ChangeListener<? super ObservableSetMultimap<K, V>> listener) {
        if (this.helper == null) {
            this.helper = new SetMultimapExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        if (this.helper == null) {
            this.helper = new SetMultimapExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    @Override
    public void addListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        if (this.helper == null) {
            this.helper = new SetMultimapExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    protected void bind(Observable ... dependencies) {
        if (dependencies != null && dependencies.length > 0) {
            if (this.dependencies == null) {
                this.dependencies = FXCollections.observableArrayList();
            }
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable d = observableArray[n2];
                if (d != null) {
                    this.dependencies.add((Object)d);
                    d.addListener(this.invalidatingDependenciesObserver);
                }
                ++n2;
            }
        }
    }

    protected abstract ObservableSetMultimap<K, V> computeValue();

    public void dispose() {
        if (this.dependencies != null) {
            this.unbind((Observable[])this.dependencies.toArray((Object[])new Observable[0]));
        }
        this.invalidatingDependenciesObserver = null;
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        if (this.emptyProperty == null) {
            this.emptyProperty = new EmptyProperty();
        }
        return this.emptyProperty;
    }

    protected void fireValueChangedEvent() {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent();
        }
    }

    protected void fireValueChangedEvent(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent(change);
        }
    }

    public ObservableSetMultimap<K, V> get() {
        if (!this.valid) {
            this.value = this.computeValue();
            this.valid = true;
            if (this.value != null) {
                this.value.addListener(this.invalidatingValueObserver);
            }
        }
        return this.value;
    }

    public ObservableList<?> getDependencies() {
        if (this.dependencies == null) {
            return FXCollections.emptyObservableList();
        }
        return FXCollections.unmodifiableObservableList(this.dependencies);
    }

    public void invalidate() {
        if (this.valid) {
            if (this.value != null) {
                this.value.removeListener(this.invalidatingValueObserver);
            }
            this.valid = false;
            this.invalidateProperties();
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    private void invalidateProperties() {
        if (this.sizeProperty != null) {
            this.sizeProperty.fireValueChangedEvent();
        }
        if (this.emptyProperty != null) {
            this.emptyProperty.fireValueChangedEvent();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void removeListener(ChangeListener<? super ObservableSetMultimap<K, V>> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    @Override
    public void removeListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        if (this.sizeProperty == null) {
            this.sizeProperty = new SizeProperty();
        }
        return this.sizeProperty;
    }

    protected void unbind(Observable ... dependencies) {
        if (this.dependencies != null) {
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable d = observableArray[n2];
                if (d != null) {
                    this.dependencies.remove((Object)d);
                    d.removeListener(this.invalidatingDependenciesObserver);
                }
                ++n2;
            }
            if (this.dependencies.size() == 0) {
                this.dependencies = null;
            }
        }
    }

    private class EmptyProperty
    extends ReadOnlyBooleanPropertyBase {
        private EmptyProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public boolean get() {
            return SetMultimapBinding.this.isEmpty();
        }

        public Object getBean() {
            return SetMultimapBinding.this;
        }

        public String getName() {
            return "empty";
        }
    }

    private class SizeProperty
    extends ReadOnlyIntegerPropertyBase {
        private SizeProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public int get() {
            return SetMultimapBinding.this.size();
        }

        public Object getBean() {
            return SetMultimapBinding.this;
        }

        public String getName() {
            return "size";
        }
    }
}

