/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableMapValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.collections.MapListenerHelperEx;

public class MapExpressionHelperEx<K, V>
extends MapListenerHelperEx<K, V> {
    private List<ChangeListener<? super ObservableMap<K, V>>> changeListeners = null;
    private ObservableMapValue<K, V> observableValue = null;
    private ObservableMap<K, V> currentValue = null;
    private boolean lockChangeListeners;

    public MapExpressionHelperEx(ObservableMapValue<K, V> observableValue) {
        super(observableValue);
        this.observableValue = observableValue;
        this.currentValue = (ObservableMap)observableValue.getValue();
    }

    public void addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener<? super ObservableMap<K, V>>>();
        }
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableMap<K, V>>>(this.changeListeners);
        }
        this.changeListeners.add(listener);
    }

    public void fireValueChangedEvent() {
        ObservableMap<K, V> oldValue = this.currentValue;
        this.currentValue = (ObservableMap)this.observableValue.getValue();
        this.notifyListeners(oldValue, this.currentValue);
    }

    @Override
    public void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
        if (change != null) {
            this.notifyInvalidationListeners();
            this.notifyMapChangeListeners(new MapListenerHelperEx.AtomicChange<K, V>(this.observableValue, change));
        }
    }

    private void notifyListeners(ObservableMap<K, V> oldValue, ObservableMap<K, V> currentValue) {
        if (currentValue != oldValue) {
            this.notifyInvalidationListeners();
            if (this.changeListeners != null) {
                try {
                    this.lockChangeListeners = true;
                    for (ChangeListener<? super ObservableMap<K, V>> changeListener : this.changeListeners) {
                        changeListener.changed(this.observableValue, oldValue, currentValue);
                    }
                }
                finally {
                    this.lockChangeListeners = false;
                }
            }
            if (oldValue == null || !oldValue.equals(currentValue)) {
                this.notifyMapListeners(oldValue, currentValue);
            }
        }
    }

    private void notifyMapListeners(ObservableMap<K, V> oldValue, ObservableMap<K, V> currentValue) {
        if (currentValue == null) {
            for (Object key : oldValue.keySet()) {
                this.notifyMapChangeListeners(new MapListenerHelperEx.AtomicChange(this.getSource(), key, oldValue.get(key), null));
            }
        } else if (oldValue == null) {
            for (Object key : currentValue.keySet()) {
                this.notifyMapChangeListeners(new MapListenerHelperEx.AtomicChange(this.getSource(), key, null, currentValue.get(key)));
            }
        } else {
            for (Object key : oldValue.keySet()) {
                if (currentValue.containsKey(key)) continue;
                this.notifyMapChangeListeners(new MapListenerHelperEx.AtomicChange(this.getSource(), key, oldValue.get(key), null));
            }
            for (Object key : currentValue.keySet()) {
                if (!(currentValue.get(key) == null ? oldValue.get(key) != null : !currentValue.get(key).equals(oldValue.get(key)))) continue;
                this.notifyMapChangeListeners(new MapListenerHelperEx.AtomicChange(this.getSource(), key, oldValue.get(key), currentValue.get(key)));
            }
        }
    }

    public void removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableMap<K, V>>>(this.changeListeners);
        }
        Iterator<ChangeListener<ObservableMap<K, V>>> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }
}

