/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples;

import com.google.inject.Guice;
import com.google.inject.Module;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;

public abstract class AbstractMvcExample
extends Application {
    protected final String title;
    private Stage primaryStage;
    private FXDomain domain;

    public AbstractMvcExample(String title) {
        this.title = title;
    }

    protected abstract Module createModule();

    protected FXViewer getContentViewer() {
        FXViewer viewer = (FXViewer)this.domain.getAdapter(AdapterKey.get(FXViewer.class, (String)"contentViewer"));
        return viewer;
    }

    protected FXDomain getDomain() {
        return this.domain;
    }

    protected Stage getPrimaryStage() {
        return this.primaryStage;
    }

    protected void hookViewers() {
        this.primaryStage.setScene(new Scene((Parent)this.getContentViewer().getCanvas()));
    }

    protected abstract void populateViewerContents();

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.domain = (FXDomain)Guice.createInjector((Module[])new Module[]{this.createModule()}).getInstance(FXDomain.class);
        this.hookViewers();
        primaryStage.setResizable(true);
        primaryStage.setWidth(640.0);
        primaryStage.setHeight(480.0);
        primaryStage.setTitle(this.title);
        primaryStage.sizeToScene();
        primaryStage.show();
        this.domain.activate();
        this.populateViewerContents();
    }
}

