/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.swt.controls;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.stage.Window;
import org.eclipse.gef4.common.reflect.ReflectionUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FXControlAdapter<T extends Control>
extends Region {
    private static final int[] FORWARD_SWT_EVENT_TYPES = new int[]{33, 34, 1, 2, 48, 3, 6, 7, 38, 32, 5, 4, 37, 10, 31, 25, 15};
    private FXCanvas canvas;
    private T control;
    private Listener swtToFXEventForwardingListener;
    private ChangeListener<Scene> sceneChangeListener;
    private ChangeListener<Window> sceneWindowChangeListener;
    private ChangeListener<Boolean> focusChangeListener;
    private IControlFactory<T> controlFactory;

    public FXControlAdapter(IControlFactory<T> controlFactory) {
        this.controlFactory = controlFactory;
        this.init();
    }

    public FXControlAdapter(T control) {
        this.canvas = this.getFXCanvas((Control)control);
        if (this.canvas == null) {
            throw new IllegalArgumentException("Control has to be parented by SwtFXCanvas.");
        }
        this.setControl(control);
        this.init();
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        if (this.control == null) {
            return 0.0;
        }
        return this.control.computeSize((int)-1, (int)-1).y;
    }

    protected double computePrefWidth(double height) {
        if (this.control == null) {
            return 0.0;
        }
        return this.control.computeSize((int)-1, (int)-1).x;
    }

    public void dispose() {
        this.unregisterListeners();
    }

    protected ObservableList<Node> getChildren() {
        return this.getChildrenUnmodifiable();
    }

    public T getControl() {
        return this.control;
    }

    protected FXCanvas getFXCanvas(Control control) {
        Control candidate = control;
        while (candidate != null) {
            if (!((candidate = candidate.getParent()) instanceof FXCanvas)) continue;
            return (FXCanvas)candidate;
        }
        return null;
    }

    protected FXCanvas getFXCanvas(Node node) {
        if (node == null) {
            return null;
        }
        return this.getFXCanvas(node.getScene());
    }

    protected FXCanvas getFXCanvas(Scene scene) {
        if (scene != null) {
            return this.getFXCanvas(scene.getWindow());
        }
        return null;
    }

    protected FXCanvas getFXCanvas(Window window) {
        if (window != null) {
            FXCanvas canvas = (FXCanvas)ReflectionUtils.getPrivateFieldValue((Object)ReflectionUtils.getPrivateFieldValue((Object)window, (String)"host"), (String)"this$0");
            return canvas;
        }
        return null;
    }

    protected void hookControl(T control) {
        FXCanvas swtFXCanvas = this.getFXCanvas((Control)control);
        if (swtFXCanvas == null || swtFXCanvas != this.canvas) {
            throw new IllegalArgumentException("Control needs to be hooked to the same canvas as this adapter.");
        }
        this.registerSwtToFXEventForwarders(swtFXCanvas);
    }

    protected void init() {
        this.focusTraversableProperty().set(true);
        this.registerListeners();
    }

    protected void registerListeners() {
        this.focusChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean hadFocus, Boolean hasFocus) {
                if (FXControlAdapter.this.control != null && !FXControlAdapter.this.control.isFocusControl() && !hadFocus.booleanValue() && hasFocus.booleanValue()) {
                    FXControlAdapter.this.control.forceFocus();
                }
            }
        };
        this.focusedProperty().addListener(this.focusChangeListener);
        this.sceneChangeListener = new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                FXControlAdapter.this.setCanvas(FXControlAdapter.this.getFXCanvas(newValue));
                if (oldValue != null) {
                    oldValue.windowProperty().removeListener(FXControlAdapter.this.sceneWindowChangeListener);
                    FXControlAdapter.this.sceneWindowChangeListener = null;
                }
                if (newValue != null) {
                    FXControlAdapter.this.sceneWindowChangeListener = (ChangeListener)new ChangeListener<Window>(){

                        public void changed(ObservableValue<? extends Window> observable, Window oldValue, Window newValue) {
                            FXControlAdapter.this.setCanvas(FXControlAdapter.this.getFXCanvas(newValue));
                        }
                    };
                    newValue.windowProperty().addListener(FXControlAdapter.this.sceneWindowChangeListener);
                }
            }
        };
        this.sceneProperty().addListener(this.sceneChangeListener);
    }

    protected void registerSwtToFXEventForwarders(final FXCanvas newCanvas) {
        this.swtToFXEventForwardingListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: {
                        FXControlAdapter.this.requestFocus();
                        break;
                    }
                    default: {
                        Point location = FXControlAdapter.this.control.getLocation();
                        event.x += location.x;
                        event.y += location.y;
                        newCanvas.notifyListeners(event.type, event);
                    }
                }
            }
        };
        int[] nArray = FORWARD_SWT_EVENT_TYPES;
        int n = FORWARD_SWT_EVENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            this.control.addListener(eventType, this.swtToFXEventForwardingListener);
            ++n2;
        }
    }

    public void relocate(double paramDouble1, double paramDouble2) {
        super.relocate(paramDouble1, paramDouble2);
        this.updateSwtBounds();
    }

    public void resize(double width, double height) {
        super.resize(width, height);
        this.updateSwtBounds();
    }

    protected void setCanvas(FXCanvas newCanvas) {
        if (this.controlFactory == null) {
            if (newCanvas != null && this.canvas != newCanvas) {
                throw new IllegalArgumentException("May not bind this adapter to another SwtFXCanvas than that of the adapted control.");
            }
        } else {
            FXCanvas oldCanvas = this.canvas;
            if (oldCanvas != null && oldCanvas != newCanvas) {
                T oldControl = this.getControl();
                this.setControl(null);
                oldControl.dispose();
                oldControl = null;
            }
            this.canvas = newCanvas;
            if (newCanvas != null && oldCanvas != newCanvas) {
                T newControl = this.controlFactory.createControl((Composite)newCanvas);
                this.setControl(newControl);
            }
        }
    }

    protected void setControl(T control) {
        T oldControl = this.control;
        if (oldControl != null) {
            this.unhookControl(oldControl);
        }
        this.control = control;
        if (control != null) {
            this.hookControl(control);
        }
    }

    protected void unhookControl(T control) {
        this.unregisterSwtToFXEventForwarders();
    }

    protected void unregisterListeners() {
        this.sceneProperty().removeListener(this.sceneChangeListener);
        this.focusedProperty().removeListener(this.focusChangeListener);
    }

    protected void unregisterSwtToFXEventForwarders() {
        int[] nArray = FORWARD_SWT_EVENT_TYPES;
        int n = FORWARD_SWT_EVENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            this.control.removeListener(eventType, this.swtToFXEventForwardingListener);
            ++n2;
        }
        this.swtToFXEventForwardingListener = null;
    }

    public void updateSwtBounds() {
        if (this.control == null) {
            return;
        }
        Bounds bounds = this.localToScene(this.getLayoutBounds());
        this.control.setBounds((int)Math.ceil(bounds.getMinX()), (int)Math.ceil(bounds.getMinY()), (int)Math.ceil(bounds.getWidth()), (int)Math.ceil(bounds.getHeight()));
    }

    public static interface IControlFactory<T extends Control> {
        public T createControl(Composite var1);
    }
}

