/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.utils;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.utils.Shape2Geometry;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class NodeUtils {
    public static boolean equals(Affine a1, Affine a2) {
        return a1.getMxx() == a2.getMxx() && a1.getMxy() == a2.getMxy() && a1.getMxz() == a2.getMxz() && a1.getMyx() == a2.getMyx() && a1.getMyy() == a2.getMyy() && a1.getMyz() == a2.getMyz() && a1.getMzx() == a2.getMzx() && a1.getMzy() == a2.getMzy() && a1.getMzz() == a2.getMzz() && a1.getTx() == a2.getTx() && a1.getTy() == a2.getTy() && a1.getTz() == a2.getTz();
    }

    public static IGeometry getGeometricOutline(Node visual) {
        if (visual instanceof Connection) {
            Node curveNode = ((Connection)visual).getCurve();
            return NodeUtils.localToParent(curveNode, NodeUtils.getGeometricOutline(curveNode));
        }
        if (visual instanceof GeometryNode) {
            return ((GeometryNode)visual).getGeometry();
        }
        if (visual instanceof Shape && !(visual instanceof Text) && !(visual instanceof SVGPath)) {
            return Shape2Geometry.toGeometry((Shape)visual);
        }
        throw new IllegalArgumentException("Cannot determine geometric outline for the given visual <" + visual + ">.");
    }

    public static AffineTransform getLocalToSceneTx(Node node) {
        AffineTransform tx = FX2Geometry.toAffineTransform((Transform)node.getLocalToParentTransform());
        Node tmp = node;
        while (tmp.getParent() != null) {
            tmp = tmp.getParent();
            tx = FX2Geometry.toAffineTransform((Transform)tmp.getLocalToParentTransform()).concatenate(tx);
        }
        return tx;
    }

    public static Node getNearestCommonAncestor(Node source, Node target) {
        if (source == target) {
            return source;
        }
        HashSet<Node> parents = new HashSet<Node>();
        Node m = source;
        Node n = target;
        while (m != null || n != null) {
            if (m != null) {
                if (parents.contains(m)) {
                    return m;
                }
                parents.add(m);
                if (n != null && parents.contains(n)) {
                    return n;
                }
                m = m.getParent();
            }
            if (n == null) continue;
            if (parents.contains(n)) {
                return n;
            }
            parents.add(n);
            if (m != null && parents.contains(m)) {
                return m;
            }
            n = n.getParent();
        }
        return null;
    }

    public static List<Node> getNodesAt(Node root, double sceneX, double sceneY) {
        ArrayList<Node> picked = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(root);
        while (!nodes.isEmpty()) {
            Node current = (Node)nodes.remove(0);
            Point2D pLocal = current.sceneToLocal(sceneX, sceneY);
            if (current.isMouseTransparent() || !current.getBoundsInLocal().contains(pLocal)) continue;
            if (current.contains(pLocal)) {
                picked.add(0, current);
            }
            if (!(current instanceof Parent)) continue;
            nodes.addAll(0, (Collection<Node>)((Parent)current).getChildrenUnmodifiable());
        }
        return picked;
    }

    public static IGeometry getResizedToShapeBounds(Node visual, IGeometry geometry) {
        Rectangle geomBounds = geometry.getBounds();
        Rectangle shapeBounds = NodeUtils.getShapeBounds(visual);
        double dw = shapeBounds.getWidth() - geomBounds.getWidth();
        double dh = shapeBounds.getHeight() - geomBounds.getHeight();
        if (dw == 0.0 && dh == 0.0) {
            return geometry;
        }
        double dx = -dw / 2.0;
        double dy = -dh / 2.0;
        GeometryNode<IGeometry> geometryNode = new GeometryNode<IGeometry>(geometry.getTransformed(new AffineTransform().translate(dx, dy)));
        geometryNode.resizeGeometry(geomBounds.getWidth() + dw, geomBounds.getHeight() + dh);
        return geometryNode.getGeometry();
    }

    public static AffineTransform getSceneToLocalTx(Node node) {
        try {
            return NodeUtils.getLocalToSceneTx(node).invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Rectangle getShapeBounds(Node node) {
        Bounds layoutBounds = node.getLayoutBounds();
        double offset = node instanceof Polygon && ((Polygon)node).getStroke() != null && ((Polygon)node).getStrokeType() != StrokeType.INSIDE ? 0.5 : 0.0;
        return (Rectangle)FX2Geometry.toRectangle((Bounds)layoutBounds).shrink(offset, offset, offset, offset);
    }

    public static IGeometry getShapeOutline(Node node) {
        try {
            IGeometry geometry = NodeUtils.getGeometricOutline(node);
            if (geometry != null) {
                return NodeUtils.getResizedToShapeBounds(node, geometry);
            }
            return FX2Geometry.toRectangle((Bounds)node.getLayoutBounds());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return FX2Geometry.toRectangle((Bounds)node.getLayoutBounds());
        }
    }

    public static IGeometry localToParent(Node n, IGeometry g) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        return g.getTransformed(localToParentTx);
    }

    public static Point localToParent(Node n, Point p) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        return localToParentTx.getTransformed(p);
    }

    public static IGeometry localToScene(Node n, IGeometry g) {
        AffineTransform localToSceneTx = NodeUtils.getLocalToSceneTx(n);
        return g.getTransformed(localToSceneTx);
    }

    public static Point localToScene(Node n, Point p) {
        AffineTransform localToSceneTx = NodeUtils.getLocalToSceneTx(n);
        return localToSceneTx.getTransformed(p);
    }

    public static IGeometry parentToLocal(Node n, IGeometry g) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        AffineTransform parentToLocalTx = null;
        try {
            parentToLocalTx = localToParentTx.getCopy().invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException(e);
        }
        return g.getTransformed(parentToLocalTx);
    }

    public static Point parentToLocal(Node n, Point p) {
        AffineTransform localToParentTx = FX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        AffineTransform parentToLocalTx = null;
        try {
            parentToLocalTx = localToParentTx.getCopy().invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException(e);
        }
        return parentToLocalTx.getTransformed(p);
    }

    public static IGeometry sceneToLocal(Node n, IGeometry g) {
        AffineTransform sceneToLocalTx = NodeUtils.getSceneToLocalTx(n);
        return g.getTransformed(sceneToLocalTx);
    }

    public static Point sceneToLocal(Node n, Point p) {
        AffineTransform sceneToLocalTx = NodeUtils.getSceneToLocalTx(n);
        return sceneToLocalTx.getTransformed(p);
    }

    public static Affine setAffine(Affine dst, Affine src) {
        dst.setMxx(src.getMxx());
        dst.setMxy(src.getMxy());
        dst.setMxz(src.getMxz());
        dst.setMyx(src.getMyx());
        dst.setMyy(src.getMyy());
        dst.setMyz(src.getMyz());
        dst.setMzx(src.getMzx());
        dst.setMzy(src.getMzy());
        dst.setMzz(src.getMzz());
        dst.setTx(src.getTx());
        dst.setTy(src.getTy());
        dst.setTz(src.getTz());
        return dst;
    }
}

