/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.anchors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.geometry.Orientation;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IComputationStrategy;
import org.eclipse.gef4.fx.anchors.ProjectionStrategy;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class OrthogonalProjectionStrategy
extends ProjectionStrategy {
    @Override
    protected Point computeProjectionInScene(List<ICurve> anchorageOutlinesInScene, Point anchoredReferencePointInScene, Set<IComputationStrategy.Parameter<?>> parameters) {
        DynamicAnchor.PreferredOrientation parameter = IComputationStrategy.Parameter.get(parameters, DynamicAnchor.PreferredOrientation.class);
        Orientation orientationHint = (Orientation)parameter.get();
        Point nearestOrthogonalProjectionInScene = null;
        double nearestOrthogonalProjectionDistance = Double.MAX_VALUE;
        for (ICurve segment : anchorageOutlinesInScene) {
            Point projection = this.getOrthogonalProjection(segment, anchoredReferencePointInScene, orientationHint);
            if (projection == null) continue;
            double distance = projection.getDistance(anchoredReferencePointInScene);
            if (nearestOrthogonalProjectionInScene != null && !(distance < nearestOrthogonalProjectionDistance)) continue;
            nearestOrthogonalProjectionInScene = projection;
            nearestOrthogonalProjectionDistance = distance;
        }
        if (nearestOrthogonalProjectionInScene != null) {
            return nearestOrthogonalProjectionInScene;
        }
        return super.computeProjectionInScene(anchorageOutlinesInScene, anchoredReferencePointInScene, parameters);
    }

    private Point getHorizontalProjection(ICurve curve, Point reference) {
        Rectangle bounds = curve.getBounds();
        Line line = new Line(bounds.getX(), reference.y, bounds.getX() + bounds.getWidth(), reference.y);
        Point projection = this.getNearestOrthogonalProjection(curve, reference, line);
        if (projection != null) {
            projection.y = reference.y;
        }
        return projection;
    }

    private Point getNearestOrthogonalProjection(ICurve curve, Point reference, Line line) {
        if (curve.overlaps((ICurve)line)) {
            ICurve[] overlaps = curve.getOverlaps((ICurve)line);
            Point nearest = null;
            double distance = 0.0;
            ICurve[] iCurveArray = overlaps;
            int n = overlaps.length;
            int n2 = 0;
            while (n2 < n) {
                ICurve overlap = iCurveArray[n2];
                Point currentNearest = Point.nearest((Point)reference, (Point[])new Point[]{overlap.getP1(), overlap.getP2()});
                double currentDistance = reference.getDistance(currentNearest);
                if (nearest == null || currentDistance < distance) {
                    nearest = currentNearest;
                    distance = currentDistance;
                }
                ++n2;
            }
            return nearest;
        }
        if (curve.intersects((ICurve)line)) {
            Point nearest = Point.nearest((Point)reference, (Point[])curve.getIntersections((ICurve)line));
            return nearest;
        }
        return null;
    }

    private Point getOrthogonalProjection(ICurve curve, Point reference, Orientation orientationHint) {
        double verticalDistance;
        Point nearestHorizonalProjection = this.getHorizontalProjection(curve, reference);
        if (nearestHorizonalProjection == null) {
            return this.getVerticalProjection(curve, reference);
        }
        if (orientationHint == Orientation.HORIZONTAL) {
            return nearestHorizonalProjection;
        }
        Point nearestVerticalProjection = this.getVerticalProjection(curve, reference);
        if (nearestVerticalProjection == null) {
            return nearestHorizonalProjection;
        }
        if (orientationHint == Orientation.VERTICAL) {
            return nearestVerticalProjection;
        }
        double horizontalDistance = nearestHorizonalProjection.getDistance(reference);
        if (horizontalDistance <= (verticalDistance = nearestVerticalProjection.getDistance(reference))) {
            return nearestHorizonalProjection;
        }
        return nearestVerticalProjection;
    }

    @Override
    public Set<Class<? extends IComputationStrategy.Parameter<?>>> getRequiredParameters() {
        HashSet dynamicParameters = new HashSet();
        dynamicParameters.addAll(super.getRequiredParameters());
        dynamicParameters.add(DynamicAnchor.PreferredOrientation.class);
        return dynamicParameters;
    }

    private Point getVerticalProjection(ICurve curve, Point reference) {
        Rectangle bounds = curve.getBounds();
        Line line = new Line(reference.x, bounds.getY(), reference.x, bounds.getY() + bounds.getHeight());
        Point projection = this.getNearestOrthogonalProjection(curve, reference, line);
        if (projection != null) {
            projection.x = reference.x;
        }
        return projection;
    }
}

