/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class SelectOperation<VR>
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Select";
    private IViewer<VR> viewer;
    private List<IContentPart<VR, ? extends VR>> initialSelection;
    private List<IContentPart<VR, ? extends VR>> toBeSelected;
    private List<IContentPart<VR, ? extends VR>> selected;

    public SelectOperation(IViewer<VR> viewer, List<? extends IContentPart<VR, ? extends VR>> toBeSelected) {
        this(DEFAULT_LABEL, viewer, toBeSelected);
    }

    public SelectOperation(String label, IViewer<VR> viewer, List<? extends IContentPart<VR, ? extends VR>> toBeSelected) {
        super(label);
        this.viewer = viewer;
        this.toBeSelected = new ArrayList<IContentPart<VR, VR>>(toBeSelected);
        SelectionModel<VR> selectionModel = this.getSelectionModel();
        this.initialSelection = new ArrayList<IContentPart<VR, VR>>(selectionModel.getSelectionUnmodifiable());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel<? extends VR> selectionModel = this.getSelectionModel();
        this.selected = new ArrayList<IContentPart<VR, VR>>(this.toBeSelected);
        this.selected.removeAll(new ArrayList<IContentPart<VR, VR>>(selectionModel.getSelectionUnmodifiable()));
        selectionModel.prependToSelection(this.selected);
        return Status.OK_STATUS;
    }

    protected SelectionModel<VR> getSelectionModel() {
        SelectionModel selectionModel = (SelectionModel)this.viewer.getAdapter(new TypeToken<SelectionModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.viewer.getClass())));
        return selectionModel;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return this.initialSelection.containsAll(this.toBeSelected);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel<? extends VR> selectionModel = this.getSelectionModel();
        selectionModel.removeFromSelection(this.selected);
        return Status.OK_STATUS;
    }
}

