/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.Set;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultFocusFeedbackPartFactory;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXFocusFeedbackPart
extends AbstractFXFeedbackPart<GeometryNode<IGeometry>> {
    private static final double DEFAULT_STROKE_WIDTH = 1.5;
    private Provider<? extends IGeometry> feedbackGeometryProvider;
    private ListChangeListener<IContentPart<Node, ? extends Node>> selectionModelObserver = new ListChangeListener<IContentPart<Node, ? extends Node>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<Node, ? extends Node>> c) {
            FXFocusFeedbackPart.this.refreshVisual();
        }
    };

    protected GeometryNode<IGeometry> createVisual() {
        GeometryNode visual = new GeometryNode();
        visual.setFill((Paint)Color.TRANSPARENT);
        visual.setMouseTransparent(true);
        visual.setManaged(false);
        visual.setStrokeType(StrokeType.OUTSIDE);
        visual.setStrokeWidth(1.5);
        visual.setStroke((Paint)this.getFocusStroke());
        return visual;
    }

    protected void doActivate() {
        super.doActivate();
        SelectionModel selectionModel = (SelectionModel)this.getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){});
        selectionModel.selectionUnmodifiableProperty().addListener(this.selectionModelObserver);
    }

    protected void doDeactivate() {
        SelectionModel selectionModel = (SelectionModel)this.getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){});
        selectionModel.selectionUnmodifiableProperty().removeListener(this.selectionModelObserver);
        super.doDeactivate();
    }

    public void doRefreshVisual(GeometryNode<IGeometry> visual) {
        Set anchorages = this.getAnchoragesUnmodifiable().keySet();
        if (anchorages.isEmpty()) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        visual.setGeometry(feedbackGeometry);
        IVisualPart anchorage = (IVisualPart)anchorages.iterator().next();
        IViewer viewer = anchorage.getRoot().getViewer();
        ObservableList selected = ((SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
            if (selected.contains(anchorage)) {
                visual.setStrokeWidth(3.0);
                visual.toBack();
            } else {
                visual.setStrokeWidth(1.5);
            }
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
            if (selected.contains(anchorage)) {
                visual.resizeGeometry(feedbackGeometry.getBounds().getWidth() + 3.0, feedbackGeometry.getBounds().getHeight() + 3.0);
                visual.setGeometry(feedbackGeometry.getTransformed(new AffineTransform(1.0, 0.0, 0.0, 1.0, -1.5, -1.5)));
            }
        }
        visual.toBack();
    }

    protected IGeometry getFeedbackGeometry() {
        return NodeUtils.sceneToLocal((Node)((Node)this.getVisual()), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    protected Color getFocusStroke() {
        Provider focusFeedbackColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"FOCUS_FEEDBACK_COLOR_PROVIDER"));
        return focusFeedbackColorProvider == null ? FXDefaultFocusFeedbackPartFactory.DEFAULT_FOCUS_FEEDBACK_COLOR : (Color)focusFeedbackColorProvider.get();
    }

    public void setGeometryProvider(Provider<? extends IGeometry> geometryProvider) {
        this.feedbackGeometryProvider = geometryProvider;
    }
}

