/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.util.Pair;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.parts.AbstractLabelPart;

public class NodeLabelPart
extends AbstractLabelPart {
    @Override
    public Point computeLabelPosition() {
        IVisualPart<Node, ? extends Node> firstAnchorage = this.getFirstAnchorage();
        Rectangle anchorageBounds = NodeUtils.sceneToLocal((Node)((Group)this.getVisual()).getParent(), (IGeometry)NodeUtils.localToScene((Node)((Node)firstAnchorage.getVisual()), (IGeometry)FX2Geometry.toRectangle((Bounds)((Node)firstAnchorage.getVisual()).getLayoutBounds()))).getBounds();
        Bounds textBounds = ((Group)this.getVisual()).getLayoutBounds();
        return new Point(anchorageBounds.getX() + anchorageBounds.getWidth() / 2.0 - textBounds.getWidth() / 2.0, anchorageBounds.getY() + anchorageBounds.getHeight());
    }

    protected Group createVisual() {
        Text text = this.createText();
        Group g = new Group();
        g.getStyleClass().add((Object)"node");
        g.getChildren().add((Object)text);
        return g;
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        HashMultimap contentAnchorages = HashMultimap.create();
        contentAnchorages.put(this.getContent().getKey(), (Object)((String)this.getContent().getValue()));
        return contentAnchorages;
    }

    protected void doRefreshVisual(Group visual) {
        IVisualPart<Node, ? extends Node> firstAnchorage;
        String label;
        org.eclipse.gef4.graph.Node node = (org.eclipse.gef4.graph.Node)this.getContent().getKey();
        ReadOnlyMapProperty attrs = node.attributesProperty();
        if (attrs.containsKey("element-external-label-css-style")) {
            String textCssStyle = ZestProperties.getExternalLabelCssStyle(node);
            ((Group)this.getVisual()).setStyle(textCssStyle);
        }
        if ((label = ZestProperties.getExternalLabel(node)) != null) {
            this.getText().setText(label);
        }
        if ((firstAnchorage = this.getFirstAnchorage()) == null) {
            return;
        }
        this.refreshPosition((Node)this.getVisual(), this.getStoredLabelPosition());
    }

    public Pair<org.eclipse.gef4.graph.Node, String> getContent() {
        return super.getContent();
    }

    public IVisualPart<Node, ? extends Node> getFirstAnchorage() {
        return this.getAnchoragesUnmodifiable().isEmpty() ? null : (IVisualPart)this.getAnchoragesUnmodifiable().keys().iterator().next();
    }
}

