/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.models;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.graph.Graph;

public class NavigationModel {
    private Map<Graph, ViewportState> viewportStates = new IdentityHashMap<Graph, ViewportState>();

    public ViewportState getViewportState(Graph graph) {
        return this.viewportStates.get(graph);
    }

    public void removeViewportState(Graph graph) {
        this.viewportStates.remove(graph);
    }

    public void setViewportState(Graph graph, ViewportState state) {
        this.viewportStates.put(graph, state);
    }

    public static class ViewportState {
        private double translateX = 0.0;
        private double translateY = 0.0;
        private double width = 0.0;
        private double height = 0.0;
        private AffineTransform contentsTransform = null;

        public ViewportState() {
            this(0.0, 0.0, 0.0, 0.0, new AffineTransform());
        }

        public ViewportState(double translateX, double translateY, double width, double height, AffineTransform contentsTransform) {
            this.translateX = translateX;
            this.translateY = translateY;
            this.width = width;
            this.height = height;
            this.contentsTransform = contentsTransform;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ViewportState other = (ViewportState)obj;
            if (this.contentsTransform == null ? other.contentsTransform != null : !this.contentsTransform.equals((Object)other.contentsTransform)) {
                return false;
            }
            if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
                return false;
            }
            if (Double.doubleToLongBits(this.translateX) != Double.doubleToLongBits(other.translateX)) {
                return false;
            }
            if (Double.doubleToLongBits(this.translateY) != Double.doubleToLongBits(other.translateY)) {
                return false;
            }
            return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width);
        }

        public AffineTransform getContentsTransform() {
            return this.contentsTransform;
        }

        public ViewportState getCopy() {
            return new ViewportState(this.translateX, this.translateY, this.width, this.height, this.contentsTransform.getCopy());
        }

        public double getHeight() {
            return this.height;
        }

        public double getTranslateX() {
            return this.translateX;
        }

        public double getTranslateY() {
            return this.translateY;
        }

        public double getWidth() {
            return this.width;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.contentsTransform == null ? 0 : this.contentsTransform.hashCode());
            long temp = Double.doubleToLongBits(this.height);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.translateX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.translateY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.width);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

