/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.binding;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import org.eclipse.gef4.common.beans.value.ObservableSetMultimapValue;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.common.collections.SetMultimapChangeListener;
import org.eclipse.gef4.common.collections.SetMultimapListenerHelper;

public class SetMultimapExpressionHelper<K, V>
extends SetMultimapListenerHelper<K, V> {
    private List<ChangeListener<? super ObservableSetMultimap<K, V>>> changeListeners = null;
    private ObservableSetMultimapValue<K, V> observableValue = null;
    private ObservableSetMultimap<K, V> currentValue = null;
    private boolean lockChangeListeners;

    public SetMultimapExpressionHelper(ObservableSetMultimapValue<K, V> observableValue) {
        super(observableValue);
        this.observableValue = observableValue;
        this.currentValue = (ObservableSetMultimap)observableValue.getValue();
    }

    public void addListener(ChangeListener<? super ObservableSetMultimap<K, V>> listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener<? super ObservableSetMultimap<K, V>>>();
        }
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableSetMultimap<K, V>>>(this.changeListeners);
        }
        this.changeListeners.add(listener);
    }

    public void fireValueChangedEvent() {
        ObservableSetMultimap<K, V> oldValue = this.currentValue;
        this.currentValue = (ObservableSetMultimap)this.observableValue.getValue();
        this.notifyListeners(oldValue, this.currentValue);
    }

    @Override
    public void fireValueChangedEvent(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
        if (change != null) {
            this.notifyInvalidationListeners();
            this.notifySetMultimapChangeListeners(new SetMultimapListenerHelper.AtomicChange<K, V>(this.observableValue, change));
        }
    }

    private void notifyListeners(ObservableSetMultimap<K, V> oldValue, ObservableSetMultimap<K, V> currentValue) {
        if (currentValue != oldValue) {
            this.notifyInvalidationListeners();
            if (this.changeListeners != null) {
                try {
                    this.lockChangeListeners = true;
                    for (ChangeListener<? super ObservableSetMultimap<K, V>> changeListener : this.changeListeners) {
                        changeListener.changed(this.observableValue, oldValue, currentValue);
                    }
                }
                finally {
                    this.lockChangeListeners = false;
                }
            }
            if (oldValue == null || !oldValue.equals(currentValue)) {
                this.notifySetMultimapListeners(oldValue, currentValue);
            }
        }
    }

    private void notifySetMultimapListeners(ObservableSetMultimap<K, V> oldValue, ObservableSetMultimap<K, V> currentValue) {
        if (currentValue == null) {
            ArrayList elementaryChanges = new ArrayList();
            for (Map.Entry entries : Multimaps.asMap(oldValue).entrySet()) {
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(entries.getKey(), (Set)entries.getValue(), Collections.emptySet()));
            }
            this.notifySetMultimapChangeListeners(new SetMultimapListenerHelper.AtomicChange(this.getSource(), HashMultimap.create(oldValue), elementaryChanges));
        } else if (oldValue == null) {
            ArrayList elementaryChanges = new ArrayList();
            for (Map.Entry entries : Multimaps.asMap(currentValue).entrySet()) {
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(entries.getKey(), Collections.emptySet(), (Set)entries.getValue()));
            }
            this.notifySetMultimapChangeListeners(new SetMultimapListenerHelper.AtomicChange(this.getSource(), HashMultimap.create(), elementaryChanges));
        } else {
            Object key;
            ArrayList elementaryChanges = new ArrayList();
            for (Map.Entry entries : Multimaps.asMap(oldValue).entrySet()) {
                key = entries.getKey();
                Set oldValues = (Set)entries.getValue();
                if (currentValue.containsKey(key)) {
                    Set newValues = currentValue.get(key);
                    HashSet addedValues = new HashSet(newValues);
                    addedValues.removeAll(oldValues);
                    HashSet removedValues = new HashSet(oldValues);
                    removedValues.removeAll(newValues);
                    if (addedValues.isEmpty() && removedValues.isEmpty()) continue;
                    elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(entries.getKey(), removedValues, addedValues));
                    continue;
                }
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(entries.getKey(), oldValues, Collections.emptySet()));
            }
            for (Map.Entry entries : Multimaps.asMap(currentValue).entrySet()) {
                key = entries.getKey();
                if (oldValue.containsKey(key)) continue;
                elementaryChanges.add(new SetMultimapListenerHelper.ElementarySubChange(key, Collections.emptySet(), (Set)entries.getValue()));
            }
            this.notifySetMultimapChangeListeners(new SetMultimapListenerHelper.AtomicChange(this.getSource(), HashMultimap.create(oldValue), elementaryChanges));
        }
    }

    public void removeListener(ChangeListener<? super ObservableSetMultimap<K, V>> listener) {
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableSetMultimap<K, V>>>(this.changeListeners);
        }
        Iterator<ChangeListener<ObservableSetMultimap<K, V>>> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }
}

