/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableListValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.collections.ListListenerHelperEx;

public class ListExpressionHelperEx<E>
extends ListListenerHelperEx<E> {
    private List<ChangeListener<? super ObservableList<E>>> changeListeners = null;
    private ObservableListValue<E> observableValue = null;
    private ObservableList<E> currentValue = null;
    private boolean lockChangeListeners;

    public ListExpressionHelperEx(ObservableListValue<E> observableValue) {
        super(observableValue);
        this.observableValue = observableValue;
        this.currentValue = (ObservableList)observableValue.getValue();
    }

    @Override
    public void addListener(ChangeListener<? super ObservableList<E>> listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener<? super ObservableList<E>>>();
        }
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableList<ChangeListener<? super ObservableList<E>>>>>(this.changeListeners);
        }
        this.changeListeners.add(listener);
    }

    public void fireValueChangedEvent() {
        ObservableList<E> oldValue = this.currentValue;
        this.currentValue = (ObservableList)this.observableValue.getValue();
        this.notifyListeners(oldValue, this.currentValue);
    }

    @Override
    public void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
        if (change != null) {
            this.notifyInvalidationListeners();
            this.notifyListChangeListeners(new ListListenerHelperEx.AtomicChange<E>(this.observableValue, change));
        }
    }

    private void notifyListeners(ObservableList<E> oldValue, ObservableList<E> currentValue) {
        if (currentValue != oldValue) {
            this.notifyInvalidationListeners();
            if (this.changeListeners != null) {
                try {
                    this.lockChangeListeners = true;
                    for (ChangeListener<? super ObservableList<E>> changeListener : this.changeListeners) {
                        changeListener.changed(this.observableValue, oldValue, currentValue);
                    }
                }
                finally {
                    this.lockChangeListeners = false;
                }
            }
            if (oldValue == null || !oldValue.equals(currentValue)) {
                this.notifyListListeners(oldValue, currentValue);
            }
        }
    }

    private void notifyListListeners(ObservableList<E> oldValue, ObservableList<E> currentValue) {
        if (currentValue == null) {
            this.notifyListChangeListeners(new ListListenerHelperEx.AtomicChange(this.getSource(), new ArrayList<E>(oldValue), ListListenerHelperEx.ElementarySubChange.removed(oldValue, 0, 0)));
        } else if (oldValue == null) {
            this.notifyListChangeListeners(new ListListenerHelperEx.AtomicChange(this.getSource(), Collections.emptyList(), ListListenerHelperEx.ElementarySubChange.added(currentValue, 0, currentValue.size())));
        } else {
            this.notifyListChangeListeners(new ListListenerHelperEx.AtomicChange(this.getSource(), new ArrayList<E>(oldValue), ListListenerHelperEx.ElementarySubChange.replaced(oldValue, currentValue, 0, currentValue.size())));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableList<ChangeListener<? super ObservableList<E>>>>>(this.changeListeners);
        }
        Iterator<ChangeListener<ObservableList<E>>> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }
}

