/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.activate;

import java.util.TreeMap;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;

public class ActivatableSupport {
    private ReadOnlyBooleanWrapper activeProperty = null;
    private IActivatable source;

    public ActivatableSupport(IActivatable source) {
        if (source == null) {
            throw new IllegalArgumentException("source may not be null.");
        }
        this.source = source;
        this.activeProperty = new ReadOnlyBooleanWrapper((Object)source, "active", false);
    }

    public void activate() {
        if (!this.isActive()) {
            this.activeProperty.set(true);
            this.activateAdapters();
        }
    }

    private void activateAdapters() {
        if (this.source instanceof IAdaptable) {
            TreeMap<AdapterKey<IActivatable>, IActivatable> activatableAdapters = new TreeMap<AdapterKey<IActivatable>, IActivatable>();
            activatableAdapters.putAll(((IAdaptable)((Object)this.source)).getAdapters(IActivatable.class));
            for (IActivatable adapter : activatableAdapters.values()) {
                adapter.activate();
            }
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.activeProperty.getReadOnlyProperty();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.deactivateAdapters();
            this.activeProperty.set(false);
        }
    }

    private void deactivateAdapters() {
        if (this.source instanceof IAdaptable) {
            TreeMap<AdapterKey<IActivatable>, IActivatable> activatableAdapters = new TreeMap<AdapterKey<IActivatable>, IActivatable>();
            activatableAdapters.putAll(((IAdaptable)((Object)this.source)).getAdapters(IActivatable.class));
            for (IActivatable adapter : activatableAdapters.values()) {
                adapter.deactivate();
            }
        }
    }

    public boolean isActive() {
        return this.activeProperty.get();
    }
}

