/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.AbstractRectangleBasedGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Arc;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.CurvedPolygon;
import org.eclipse.gef4.geometry.planar.Ellipse;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.ShapeUtils;

public final class RoundedRectangle
extends AbstractRectangleBasedGeometry<RoundedRectangle, PolyBezier>
implements IShape {
    private static final long serialVersionUID = 1L;
    private double arcWidth;
    private double arcHeight;

    public RoundedRectangle(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        super(x, y, width, height);
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public RoundedRectangle(Rectangle r, double arcWidth, double arcHeight) {
        this(r.getX(), r.getY(), r.getWidth(), r.getHeight(), arcWidth, arcHeight);
    }

    @Override
    public boolean contains(IGeometry g) {
        return ShapeUtils.contains((IShape)this, g);
    }

    @Override
    public boolean contains(Point p) {
        Rectangle testRect = this.getBounds();
        if (!testRect.contains(p)) {
            return false;
        }
        double aw = this.getEffectiveArcWidth() / 2.0;
        double ah = this.getEffectiveArcHeight() / 2.0;
        testRect.setBounds(this.x, this.y + ah, this.width, this.height - 2.0 * ah);
        if (testRect.contains(p)) {
            return true;
        }
        testRect.setBounds(this.x + aw, this.y, this.width - 2.0 * aw, this.height);
        if (testRect.contains(p)) {
            return true;
        }
        Ellipse e = new Ellipse(this.x, this.y, 2.0 * aw, 2.0 * ah);
        if (e.contains(p)) {
            return true;
        }
        e.setBounds(this.x, this.y + this.height - 2.0 * ah, 2.0 * aw, 2.0 * ah);
        if (e.contains(p)) {
            return true;
        }
        e.setBounds(this.x + this.width - 2.0 * aw, this.y, 2.0 * aw, 2.0 * ah);
        if (e.contains(p)) {
            return true;
        }
        e.setBounds(this.x + this.width - 2.0 * aw, this.y + this.height - 2.0 * ah, 2.0 * aw, 2.0 * ah);
        return e.contains(p);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RoundedRectangle)) {
            return false;
        }
        RoundedRectangle o = (RoundedRectangle)obj;
        return PrecisionUtils.equal(this.x, o.x) && PrecisionUtils.equal(this.y, o.y) && PrecisionUtils.equal(this.width, o.width) && PrecisionUtils.equal(this.height, o.height) && PrecisionUtils.equal(this.arcWidth, o.arcWidth) && PrecisionUtils.equal(this.arcHeight, o.arcHeight);
    }

    public double getArcHeight() {
        return this.arcHeight;
    }

    public double getArcWidth() {
        return this.arcWidth;
    }

    public Line getBottom() {
        double aw = this.getEffectiveArcWidth() / 2.0;
        return new Line(this.x + aw, this.y + this.height, this.x + this.width - aw, this.y + this.height);
    }

    public Arc getBottomLeftArc() {
        double aw = this.getEffectiveArcWidth() / 2.0;
        double ah = this.getEffectiveArcHeight() / 2.0;
        return new Arc(this.x, this.y + this.height - 2.0 * ah, 2.0 * aw, 2.0 * ah, Angle.fromDeg(180.0), Angle.fromDeg(90.0));
    }

    public Arc getBottomRightArc() {
        double aw = this.getEffectiveArcWidth() / 2.0;
        double ah = this.getEffectiveArcHeight() / 2.0;
        return new Arc(this.x + this.width - 2.0 * aw, this.y + this.height - 2.0 * ah, 2.0 * aw, 2.0 * ah, Angle.fromDeg(270.0), Angle.fromDeg(90.0));
    }

    @Override
    public RoundedRectangle getCopy() {
        return new RoundedRectangle(this.x, this.y, this.width, this.height, this.arcWidth, this.arcHeight);
    }

    protected double getEffectiveArcHeight() {
        double ah = this.arcHeight < 0.0 ? 0.0 : this.arcHeight;
        return ah > this.height ? this.height : ah;
    }

    protected double getEffectiveArcWidth() {
        double aw = this.arcWidth < 0.0 ? 0.0 : this.arcWidth;
        return aw > this.width ? this.width : aw;
    }

    public Line getLeft() {
        double ah = this.getEffectiveArcHeight() / 2.0;
        return new Line(this.x, this.y + ah, this.x, this.y + this.height - ah);
    }

    @Override
    public PolyBezier getOutline() {
        return ShapeUtils.getOutline(this);
    }

    public BezierCurve[] getOutlineSegments() {
        double aw = this.getEffectiveArcWidth() / 2.0;
        double ah = this.getEffectiveArcHeight() / 2.0;
        return new BezierCurve[]{ShapeUtils.computeEllipticalArcApproximation(this.x + this.width - 2.0 * aw, this.y, 2.0 * aw, 2.0 * ah, Angle.fromDeg(0.0), Angle.fromDeg(90.0)), new Line(this.x + this.width - aw, this.y, this.x + aw, this.y), ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, 2.0 * aw, 2.0 * ah, Angle.fromDeg(90.0), Angle.fromDeg(180.0)), new Line(this.x, this.y + ah, this.x, this.y + this.height - ah), ShapeUtils.computeEllipticalArcApproximation(this.x, this.y + this.height - 2.0 * ah, 2.0 * aw, 2.0 * ah, Angle.fromDeg(180.0), Angle.fromDeg(270.0)), new Line(this.x + aw, this.y + this.height, this.x + this.width - aw, this.y + this.height), ShapeUtils.computeEllipticalArcApproximation(this.x + this.width - 2.0 * aw, this.y + this.height - 2.0 * ah, 2.0 * aw, 2.0 * ah, Angle.fromDeg(270.0), Angle.fromDeg(360.0)), new Line(this.x + this.width, this.y + this.height - ah, this.x + this.width, this.y + ah)};
    }

    public Line getRight() {
        double ah = this.getEffectiveArcHeight() / 2.0;
        return new Line(this.x + this.width, this.y + ah, this.x + this.width, this.y + this.height - ah);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle) {
        return this.getOutline().rotateCCW(angle);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, double cx, double cy) {
        return this.getOutline().rotateCCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, Point center) {
        return this.getOutline().rotateCCW(angle, center);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle) {
        return this.getOutline().rotateCW(angle);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, double cx, double cy) {
        return this.getOutline().rotateCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, Point center) {
        return this.getOutline().rotateCW(angle, center);
    }

    public Line getTop() {
        double aw = this.getEffectiveArcWidth() / 2.0;
        return new Line(this.x + aw, this.y, this.x + this.width - aw, this.y);
    }

    public Arc getTopLeftArc() {
        return new Arc(this.x, this.y, this.getEffectiveArcWidth(), this.getEffectiveArcHeight(), Angle.fromDeg(90.0), Angle.fromDeg(90.0));
    }

    public Arc getTopRightArc() {
        double aw = this.getEffectiveArcWidth() / 2.0;
        double ah = this.getEffectiveArcHeight() / 2.0;
        return new Arc(this.x + this.width - 2.0 * aw, this.y, 2.0 * aw, 2.0 * ah, Angle.fromDeg(0.0), Angle.fromDeg(90.0));
    }

    @Override
    public CurvedPolygon getTransformed(AffineTransform t) {
        return new CurvedPolygon(this.getOutlineSegments()).getTransformed(t);
    }

    public RoundedRectangle setArcHeight(double arcHeight) {
        this.arcHeight = arcHeight;
        return this;
    }

    public RoundedRectangle setArcWidth(double arcWidth) {
        this.arcWidth = arcWidth;
        return this;
    }

    @Override
    public Path toPath() {
        return CurveUtils.toPath(this.getOutlineSegments());
    }

    public String toString() {
        return "RoundedRectangle(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", " + this.arcWidth + ", " + this.arcHeight + ")";
    }
}

