/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.examples;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.zest.fx.ZestFxModule;

public abstract class AbstractZestExample
extends Application {
    private static int id = 0;
    protected static final String ID = "element-css-id";
    protected static final String LABEL = "element-label";
    protected static final String CSS_CLASS = "element-css-class";
    protected static final String LAYOUT_IRRELEVANT = "element-layout-irrelevant";
    private String title;
    protected IDomain domain;
    protected IViewer viewer;
    protected Graph graph;

    protected static String genId() {
        return Integer.toString(id++);
    }

    protected static Edge e(Node n, Node m, Object ... attr) {
        String label = String.valueOf((String)n.attributesProperty().get((Object)LABEL)) + (String)m.attributesProperty().get((Object)LABEL);
        Edge.Builder builder = new Edge.Builder(n, m).attr(LABEL, (Object)label).attr(ID, (Object)AbstractZestExample.genId());
        int i = 0;
        while (i < attr.length) {
            builder.attr(attr[i].toString(), attr[i + 1]);
            i += 2;
        }
        return builder.buildEdge();
    }

    protected static Edge e(Graph graph, Node n, Node m, Object ... attr) {
        Edge edge = AbstractZestExample.e(n, m, attr);
        graph.getEdges().add((Object)edge);
        return edge;
    }

    protected static Node n(Object ... attr) {
        Node.Builder builder = new Node.Builder();
        String id = AbstractZestExample.genId();
        builder.attr(ID, (Object)id).attr(LABEL, (Object)id);
        int i = 0;
        while (i < attr.length) {
            builder.attr(attr[i].toString(), attr[i + 1]);
            i += 2;
        }
        return builder.buildNode();
    }

    protected static Node n(Graph graph, Object ... attr) {
        Node node = AbstractZestExample.n(attr);
        graph.getNodes().add((Object)node);
        return node;
    }

    public AbstractZestExample(String title) {
        this.title = title;
    }

    protected abstract Graph createGraph();

    public void start(Stage primaryStage) throws Exception {
        this.graph = this.createGraph();
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModule()});
        this.domain = (IDomain)injector.getInstance(IDomain.class);
        this.viewer = (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
        primaryStage.setScene(this.createScene(this.viewer));
        primaryStage.setResizable(true);
        primaryStage.setWidth((double)this.getStageWidth());
        primaryStage.setHeight((double)this.getStageHeight());
        primaryStage.setTitle(this.title);
        primaryStage.show();
        this.domain.activate();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractZestExample.this.viewer.getContents().setAll(Collections.singletonList(AbstractZestExample.this.graph));
            }
        });
    }

    protected Scene createScene(IViewer viewer) {
        return new Scene(viewer.getCanvas());
    }

    protected int getStageHeight() {
        return 480;
    }

    protected int getStageWidth() {
        return 640;
    }

    protected Module createModule() {
        return new ZestFxModule();
    }
}

