package org.eclipse.gef.dot.internal.ide.language.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.gef.dot.internal.language.services.DotPointGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotPointParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ExclamationMark", "Comma", "RULE_DOUBLE", "RULE_WS"
    };
    public static final int RULE_WS=7;
    public static final int Comma=5;
    public static final int RULE_DOUBLE=6;
    public static final int EOF=-1;
    public static final int ExclamationMark=4;

    // delegates
    // delegators


        public InternalDotPointParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalDotPointParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalDotPointParser.tokenNames; }
    public String getGrammarFileName() { return "InternalDotPointParser.g"; }


    	private DotPointGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("ExclamationMark", "'!'");
    		tokenNameToValue.put("Comma", "','");
    	}

    	public void setGrammarAccess(DotPointGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}



    // $ANTLR start "entryRulePoint"
    // InternalDotPointParser.g:57:1: entryRulePoint : rulePoint EOF ;
    public final void entryRulePoint() throws RecognitionException {
        try {
            // InternalDotPointParser.g:58:1: ( rulePoint EOF )
            // InternalDotPointParser.g:59:1: rulePoint EOF
            {
             before(grammarAccess.getPointRule()); 
            pushFollow(FOLLOW_1);
            rulePoint();

            state._fsp--;

             after(grammarAccess.getPointRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRulePoint"


    // $ANTLR start "rulePoint"
    // InternalDotPointParser.g:66:1: rulePoint : ( ( rule__Point__Group__0 ) ) ;
    public final void rulePoint() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:70:2: ( ( ( rule__Point__Group__0 ) ) )
            // InternalDotPointParser.g:71:2: ( ( rule__Point__Group__0 ) )
            {
            // InternalDotPointParser.g:71:2: ( ( rule__Point__Group__0 ) )
            // InternalDotPointParser.g:72:3: ( rule__Point__Group__0 )
            {
             before(grammarAccess.getPointAccess().getGroup()); 
            // InternalDotPointParser.g:73:3: ( rule__Point__Group__0 )
            // InternalDotPointParser.g:73:4: rule__Point__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Point__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rulePoint"


    // $ANTLR start "rule__Point__Group__0"
    // InternalDotPointParser.g:81:1: rule__Point__Group__0 : rule__Point__Group__0__Impl rule__Point__Group__1 ;
    public final void rule__Point__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:85:1: ( rule__Point__Group__0__Impl rule__Point__Group__1 )
            // InternalDotPointParser.g:86:2: rule__Point__Group__0__Impl rule__Point__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__Point__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__0"


    // $ANTLR start "rule__Point__Group__0__Impl"
    // InternalDotPointParser.g:93:1: rule__Point__Group__0__Impl : ( ( rule__Point__XAssignment_0 ) ) ;
    public final void rule__Point__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:97:1: ( ( ( rule__Point__XAssignment_0 ) ) )
            // InternalDotPointParser.g:98:1: ( ( rule__Point__XAssignment_0 ) )
            {
            // InternalDotPointParser.g:98:1: ( ( rule__Point__XAssignment_0 ) )
            // InternalDotPointParser.g:99:2: ( rule__Point__XAssignment_0 )
            {
             before(grammarAccess.getPointAccess().getXAssignment_0()); 
            // InternalDotPointParser.g:100:2: ( rule__Point__XAssignment_0 )
            // InternalDotPointParser.g:100:3: rule__Point__XAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__Point__XAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getXAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__0__Impl"


    // $ANTLR start "rule__Point__Group__1"
    // InternalDotPointParser.g:108:1: rule__Point__Group__1 : rule__Point__Group__1__Impl rule__Point__Group__2 ;
    public final void rule__Point__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:112:1: ( rule__Point__Group__1__Impl rule__Point__Group__2 )
            // InternalDotPointParser.g:113:2: rule__Point__Group__1__Impl rule__Point__Group__2
            {
            pushFollow(FOLLOW_4);
            rule__Point__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__1"


    // $ANTLR start "rule__Point__Group__1__Impl"
    // InternalDotPointParser.g:120:1: rule__Point__Group__1__Impl : ( Comma ) ;
    public final void rule__Point__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:124:1: ( ( Comma ) )
            // InternalDotPointParser.g:125:1: ( Comma )
            {
            // InternalDotPointParser.g:125:1: ( Comma )
            // InternalDotPointParser.g:126:2: Comma
            {
             before(grammarAccess.getPointAccess().getCommaKeyword_1()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getCommaKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__1__Impl"


    // $ANTLR start "rule__Point__Group__2"
    // InternalDotPointParser.g:135:1: rule__Point__Group__2 : rule__Point__Group__2__Impl rule__Point__Group__3 ;
    public final void rule__Point__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:139:1: ( rule__Point__Group__2__Impl rule__Point__Group__3 )
            // InternalDotPointParser.g:140:2: rule__Point__Group__2__Impl rule__Point__Group__3
            {
            pushFollow(FOLLOW_5);
            rule__Point__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__2"


    // $ANTLR start "rule__Point__Group__2__Impl"
    // InternalDotPointParser.g:147:1: rule__Point__Group__2__Impl : ( ( rule__Point__YAssignment_2 ) ) ;
    public final void rule__Point__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:151:1: ( ( ( rule__Point__YAssignment_2 ) ) )
            // InternalDotPointParser.g:152:1: ( ( rule__Point__YAssignment_2 ) )
            {
            // InternalDotPointParser.g:152:1: ( ( rule__Point__YAssignment_2 ) )
            // InternalDotPointParser.g:153:2: ( rule__Point__YAssignment_2 )
            {
             before(grammarAccess.getPointAccess().getYAssignment_2()); 
            // InternalDotPointParser.g:154:2: ( rule__Point__YAssignment_2 )
            // InternalDotPointParser.g:154:3: rule__Point__YAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__Point__YAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getYAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__2__Impl"


    // $ANTLR start "rule__Point__Group__3"
    // InternalDotPointParser.g:162:1: rule__Point__Group__3 : rule__Point__Group__3__Impl rule__Point__Group__4 ;
    public final void rule__Point__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:166:1: ( rule__Point__Group__3__Impl rule__Point__Group__4 )
            // InternalDotPointParser.g:167:2: rule__Point__Group__3__Impl rule__Point__Group__4
            {
            pushFollow(FOLLOW_5);
            rule__Point__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__3"


    // $ANTLR start "rule__Point__Group__3__Impl"
    // InternalDotPointParser.g:174:1: rule__Point__Group__3__Impl : ( ( rule__Point__Group_3__0 )? ) ;
    public final void rule__Point__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:178:1: ( ( ( rule__Point__Group_3__0 )? ) )
            // InternalDotPointParser.g:179:1: ( ( rule__Point__Group_3__0 )? )
            {
            // InternalDotPointParser.g:179:1: ( ( rule__Point__Group_3__0 )? )
            // InternalDotPointParser.g:180:2: ( rule__Point__Group_3__0 )?
            {
             before(grammarAccess.getPointAccess().getGroup_3()); 
            // InternalDotPointParser.g:181:2: ( rule__Point__Group_3__0 )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==Comma) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // InternalDotPointParser.g:181:3: rule__Point__Group_3__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Point__Group_3__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getPointAccess().getGroup_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__3__Impl"


    // $ANTLR start "rule__Point__Group__4"
    // InternalDotPointParser.g:189:1: rule__Point__Group__4 : rule__Point__Group__4__Impl ;
    public final void rule__Point__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:193:1: ( rule__Point__Group__4__Impl )
            // InternalDotPointParser.g:194:2: rule__Point__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Point__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__4"


    // $ANTLR start "rule__Point__Group__4__Impl"
    // InternalDotPointParser.g:200:1: rule__Point__Group__4__Impl : ( ( rule__Point__InputOnlyAssignment_4 )? ) ;
    public final void rule__Point__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:204:1: ( ( ( rule__Point__InputOnlyAssignment_4 )? ) )
            // InternalDotPointParser.g:205:1: ( ( rule__Point__InputOnlyAssignment_4 )? )
            {
            // InternalDotPointParser.g:205:1: ( ( rule__Point__InputOnlyAssignment_4 )? )
            // InternalDotPointParser.g:206:2: ( rule__Point__InputOnlyAssignment_4 )?
            {
             before(grammarAccess.getPointAccess().getInputOnlyAssignment_4()); 
            // InternalDotPointParser.g:207:2: ( rule__Point__InputOnlyAssignment_4 )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==ExclamationMark) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // InternalDotPointParser.g:207:3: rule__Point__InputOnlyAssignment_4
                    {
                    pushFollow(FOLLOW_2);
                    rule__Point__InputOnlyAssignment_4();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getPointAccess().getInputOnlyAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group__4__Impl"


    // $ANTLR start "rule__Point__Group_3__0"
    // InternalDotPointParser.g:216:1: rule__Point__Group_3__0 : rule__Point__Group_3__0__Impl rule__Point__Group_3__1 ;
    public final void rule__Point__Group_3__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:220:1: ( rule__Point__Group_3__0__Impl rule__Point__Group_3__1 )
            // InternalDotPointParser.g:221:2: rule__Point__Group_3__0__Impl rule__Point__Group_3__1
            {
            pushFollow(FOLLOW_4);
            rule__Point__Group_3__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Point__Group_3__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__0"


    // $ANTLR start "rule__Point__Group_3__0__Impl"
    // InternalDotPointParser.g:228:1: rule__Point__Group_3__0__Impl : ( Comma ) ;
    public final void rule__Point__Group_3__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:232:1: ( ( Comma ) )
            // InternalDotPointParser.g:233:1: ( Comma )
            {
            // InternalDotPointParser.g:233:1: ( Comma )
            // InternalDotPointParser.g:234:2: Comma
            {
             before(grammarAccess.getPointAccess().getCommaKeyword_3_0()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getCommaKeyword_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__0__Impl"


    // $ANTLR start "rule__Point__Group_3__1"
    // InternalDotPointParser.g:243:1: rule__Point__Group_3__1 : rule__Point__Group_3__1__Impl ;
    public final void rule__Point__Group_3__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:247:1: ( rule__Point__Group_3__1__Impl )
            // InternalDotPointParser.g:248:2: rule__Point__Group_3__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Point__Group_3__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__1"


    // $ANTLR start "rule__Point__Group_3__1__Impl"
    // InternalDotPointParser.g:254:1: rule__Point__Group_3__1__Impl : ( ( rule__Point__ZAssignment_3_1 ) ) ;
    public final void rule__Point__Group_3__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:258:1: ( ( ( rule__Point__ZAssignment_3_1 ) ) )
            // InternalDotPointParser.g:259:1: ( ( rule__Point__ZAssignment_3_1 ) )
            {
            // InternalDotPointParser.g:259:1: ( ( rule__Point__ZAssignment_3_1 ) )
            // InternalDotPointParser.g:260:2: ( rule__Point__ZAssignment_3_1 )
            {
             before(grammarAccess.getPointAccess().getZAssignment_3_1()); 
            // InternalDotPointParser.g:261:2: ( rule__Point__ZAssignment_3_1 )
            // InternalDotPointParser.g:261:3: rule__Point__ZAssignment_3_1
            {
            pushFollow(FOLLOW_2);
            rule__Point__ZAssignment_3_1();

            state._fsp--;


            }

             after(grammarAccess.getPointAccess().getZAssignment_3_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__Group_3__1__Impl"


    // $ANTLR start "rule__Point__XAssignment_0"
    // InternalDotPointParser.g:270:1: rule__Point__XAssignment_0 : ( RULE_DOUBLE ) ;
    public final void rule__Point__XAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:274:1: ( ( RULE_DOUBLE ) )
            // InternalDotPointParser.g:275:2: ( RULE_DOUBLE )
            {
            // InternalDotPointParser.g:275:2: ( RULE_DOUBLE )
            // InternalDotPointParser.g:276:3: RULE_DOUBLE
            {
             before(grammarAccess.getPointAccess().getXDOUBLETerminalRuleCall_0_0()); 
            match(input,RULE_DOUBLE,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getXDOUBLETerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__XAssignment_0"


    // $ANTLR start "rule__Point__YAssignment_2"
    // InternalDotPointParser.g:285:1: rule__Point__YAssignment_2 : ( RULE_DOUBLE ) ;
    public final void rule__Point__YAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:289:1: ( ( RULE_DOUBLE ) )
            // InternalDotPointParser.g:290:2: ( RULE_DOUBLE )
            {
            // InternalDotPointParser.g:290:2: ( RULE_DOUBLE )
            // InternalDotPointParser.g:291:3: RULE_DOUBLE
            {
             before(grammarAccess.getPointAccess().getYDOUBLETerminalRuleCall_2_0()); 
            match(input,RULE_DOUBLE,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getYDOUBLETerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__YAssignment_2"


    // $ANTLR start "rule__Point__ZAssignment_3_1"
    // InternalDotPointParser.g:300:1: rule__Point__ZAssignment_3_1 : ( RULE_DOUBLE ) ;
    public final void rule__Point__ZAssignment_3_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:304:1: ( ( RULE_DOUBLE ) )
            // InternalDotPointParser.g:305:2: ( RULE_DOUBLE )
            {
            // InternalDotPointParser.g:305:2: ( RULE_DOUBLE )
            // InternalDotPointParser.g:306:3: RULE_DOUBLE
            {
             before(grammarAccess.getPointAccess().getZDOUBLETerminalRuleCall_3_1_0()); 
            match(input,RULE_DOUBLE,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getZDOUBLETerminalRuleCall_3_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__ZAssignment_3_1"


    // $ANTLR start "rule__Point__InputOnlyAssignment_4"
    // InternalDotPointParser.g:315:1: rule__Point__InputOnlyAssignment_4 : ( ( ExclamationMark ) ) ;
    public final void rule__Point__InputOnlyAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotPointParser.g:319:1: ( ( ( ExclamationMark ) ) )
            // InternalDotPointParser.g:320:2: ( ( ExclamationMark ) )
            {
            // InternalDotPointParser.g:320:2: ( ( ExclamationMark ) )
            // InternalDotPointParser.g:321:3: ( ExclamationMark )
            {
             before(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 
            // InternalDotPointParser.g:322:3: ( ExclamationMark )
            // InternalDotPointParser.g:323:4: ExclamationMark
            {
             before(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 
            match(input,ExclamationMark,FOLLOW_2); 
             after(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 

            }

             after(grammarAccess.getPointAccess().getInputOnlyExclamationMarkKeyword_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Point__InputOnlyAssignment_4"

    // Delegated rules


 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000000000030L});

}