/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.beans.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableSetValue;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.eclipse.gef.common.collections.SetListenerHelperEx;

public class SetExpressionHelperEx<E>
extends SetListenerHelperEx<E> {
    private List<ChangeListener<? super ObservableSet<E>>> changeListeners = null;
    private ObservableSetValue<E> observableValue = null;
    private ObservableSet<E> currentValue = null;
    private boolean lockChangeListeners;

    public SetExpressionHelperEx(ObservableSetValue<E> observableValue) {
        super(observableValue);
        this.observableValue = observableValue;
        this.currentValue = (ObservableSet)observableValue.getValue();
    }

    @Override
    public void addListener(ChangeListener<? super ObservableSet<E>> listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener<? super ObservableSet<E>>>();
        }
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableSet<ChangeListener<? super ObservableSet<E>>>>>(this.changeListeners);
        }
        this.changeListeners.add(listener);
    }

    public void fireValueChangedEvent() {
        ObservableSet<E> oldValue = this.currentValue;
        this.currentValue = (ObservableSet)this.observableValue.getValue();
        this.notifyListeners(oldValue, this.currentValue);
    }

    @Override
    public void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
        if (change != null) {
            this.notifyInvalidationListeners();
            this.notifySetChangeListeners(new SetListenerHelperEx.AtomicChange<E>(this.observableValue, change));
        }
    }

    private void notifyListeners(ObservableSet<E> oldValue, ObservableSet<E> currentValue) {
        if (currentValue != oldValue) {
            this.notifyInvalidationListeners();
            if (this.changeListeners != null) {
                try {
                    this.lockChangeListeners = true;
                    for (ChangeListener<? super ObservableSet<E>> changeListener : this.changeListeners) {
                        changeListener.changed(this.observableValue, oldValue, currentValue);
                    }
                }
                finally {
                    this.lockChangeListeners = false;
                }
            }
            if (oldValue == null || !oldValue.equals(currentValue)) {
                this.notifySetListeners(oldValue, currentValue);
            }
        }
    }

    private void notifySetListeners(ObservableSet<E> oldValue, ObservableSet<E> currentValue) {
        if (currentValue == null) {
            for (Object e : oldValue) {
                this.notifySetChangeListeners(new SetListenerHelperEx.AtomicChange<Object>((ObservableSet<Object>)this.getSource(), e, null));
            }
        } else if (oldValue == null) {
            for (Object e : currentValue) {
                this.notifySetChangeListeners(new SetListenerHelperEx.AtomicChange<Object>((ObservableSet<Object>)this.getSource(), null, e));
            }
        } else {
            for (Object e : oldValue) {
                if (currentValue.contains(e)) continue;
                this.notifySetChangeListeners(new SetListenerHelperEx.AtomicChange<Object>((ObservableSet<Object>)this.getSource(), e, null));
            }
            for (Object e : currentValue) {
                if (oldValue.contains(e)) continue;
                this.notifySetChangeListeners(new SetListenerHelperEx.AtomicChange<Object>((ObservableSet<Object>)this.getSource(), null, e));
            }
        }
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableSet<E>> listener) {
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableSet<ChangeListener<? super ObservableSet<E>>>>>(this.changeListeners);
        }
        Iterator<ChangeListener<ObservableSet<E>>> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }
}

