/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class ConnectionClickableAreaBehavior
extends AbstractBehavior {
    private static final double ABSOLUTE_CLICKABLE_WIDTH = 8.0;
    private DoubleBinding clickableAreaBinding;
    private final ChangeListener<? super Number> scaleXListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            ConnectionClickableAreaBehavior.this.clickableAreaBinding.invalidate();
        }
    };

    @Override
    protected void doActivate() {
        this.clickableAreaBinding = new DoubleBinding(){

            protected double computeValue() {
                double localClickableWidth = 8.0 / ((InfiniteCanvasViewer)ConnectionClickableAreaBehavior.this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().getMxx();
                return Math.min(localClickableWidth, 8.0);
            }
        };
        ((GeometryNode)this.getHost().getVisual().getCurve()).clickableAreaWidthProperty().bind((ObservableValue)this.clickableAreaBinding);
        ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().mxxProperty().addListener(this.scaleXListener);
    }

    @Override
    protected void doDeactivate() {
        this.clickableAreaBinding.dispose();
        ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().mxxProperty().removeListener(this.scaleXListener);
    }

    public IVisualPart<Connection> getHost() {
        return super.getHost();
    }
}

