/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.ui.properties;

import org.eclipse.gef.mvc.examples.logo.model.GeometricCurve;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class GeometricCurvePropertySource
implements IPropertySource {
    public static final IPropertyDescriptor SOURCE_DECORATION_PROPERTY = new ComboBoxPropertyDescriptor((Object)"sourceDecoration", "Source Decoration", new String[]{GeometricCurve.Decoration.NONE.name(), GeometricCurve.Decoration.ARROW.name(), GeometricCurve.Decoration.CIRCLE.name()});
    public static final IPropertyDescriptor TARGET_DECORATION_PROPERTY = new ComboBoxPropertyDescriptor((Object)"targetDecoration", "Target Decoration", new String[]{GeometricCurve.Decoration.NONE.name(), GeometricCurve.Decoration.ARROW.name(), GeometricCurve.Decoration.CIRCLE.name()});
    public static final IPropertyDescriptor STROKE_WIDTH_PROPERTY = new TextPropertyDescriptor((Object)"strokeWidth", "Stroke Width");
    public static final IPropertyDescriptor ROUTING_STYLE_PROPERTY = new ComboBoxPropertyDescriptor((Object)"routingStyle", "Routing Style", new String[]{GeometricCurve.RoutingStyle.STRAIGHT.name(), GeometricCurve.RoutingStyle.ORTHOGONAL.name()});
    private GeometricCurve curve;

    public GeometricCurvePropertySource(GeometricCurve curve) {
        this.curve = curve;
    }

    public GeometricCurve getCurve() {
        return this.curve;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{SOURCE_DECORATION_PROPERTY, TARGET_DECORATION_PROPERTY, STROKE_WIDTH_PROPERTY, ROUTING_STYLE_PROPERTY};
    }

    public Object getPropertyValue(Object id) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            return this.curve.getSourceDecoration().ordinal();
        }
        if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            return this.curve.getTargetDecoration().ordinal();
        }
        if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            return new Double(this.curve.getStrokeWidth()).toString();
        }
        if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            return this.curve.getRoutingStyle().ordinal();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            return !this.curve.getSourceDecoration().equals((Object)GeometricCurve.Decoration.NONE);
        }
        if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            return !this.curve.getTargetDecoration().equals((Object)GeometricCurve.Decoration.NONE);
        }
        if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            return this.curve.getStrokeWidth() != 1.0;
        }
        if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            return !this.curve.getRoutingStyle().equals((Object)GeometricCurve.RoutingStyle.STRAIGHT);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setSourceDecoration(GeometricCurve.Decoration.NONE);
        } else if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setTargetDecoration(GeometricCurve.Decoration.NONE);
        } else if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            this.curve.setStrokeWidth(1.0);
        } else if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            this.curve.setRoutingStyle(GeometricCurve.RoutingStyle.STRAIGHT);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setSourceDecoration(GeometricCurve.Decoration.values()[(Integer)value]);
        } else if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setTargetDecoration(GeometricCurve.Decoration.values()[(Integer)value]);
        } else if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            this.curve.setStrokeWidth(Double.parseDouble((String)value));
        } else if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            this.curve.setRoutingStyle(GeometricCurve.RoutingStyle.values()[(Integer)value]);
        }
    }
}

