/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.cloudio.internal.ui.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.cloudio.internal.ui.util.CloudMatrix;
import org.eclipse.gef.cloudio.internal.ui.util.SmallRect;
import org.eclipse.swt.graphics.Point;

public class RectTree {
    private final int minResolution;
    private short xOffset;
    private short yOffset;
    private RectNode root;
    private LinkedList<RectNode> leaves;
    public static short EMPTY = (short)-3;
    public static short MISC = (short)-2;
    public static short BACKGROUND = (short)-1;

    public RectTree(SmallRect root, int minResolution) {
        this.minResolution = minResolution;
        this.root = new RectNode(root);
    }

    public void insert(SmallRect r, short id) {
        this.root.insert(r, id);
    }

    public void move(int x, int y) {
        this.xOffset = (short)x;
        this.yOffset = (short)y;
    }

    public boolean fits(CloudMatrix mainTree) {
        LinkedList<RectNode> leaves = this.getLeaves();
        Iterator nodes = leaves.iterator();
        while (nodes.hasNext()) {
            RectNode node = (RectNode)nodes.next();
            if (mainTree.isEmpty((node.rect.x + this.xOffset) / this.minResolution, (node.rect.y + this.yOffset) / this.minResolution)) continue;
            nodes.remove();
            leaves.addFirst(node);
            return false;
        }
        return true;
    }

    LinkedList<RectNode> getLeaves() {
        if (this.leaves == null) {
            this.leaves = new LinkedList();
            this.addLeaves(this.leaves, this.root);
        }
        return this.leaves;
    }

    private void addLeaves(List<RectNode> leaves, RectNode current) {
        if (current.children == null) {
            if (current.filled != EMPTY) {
                leaves.add(current);
            }
        } else {
            int i = 0;
            while (i < 4) {
                if (current.children[i] != null) {
                    this.addLeaves(leaves, current.children[i]);
                }
                ++i;
            }
        }
    }

    public void place(CloudMatrix mainTree, short id) {
        LinkedList<RectNode> leaves = this.getLeaves();
        for (RectNode node : leaves) {
            mainTree.set(node, id, this.xOffset, this.yOffset, this.minResolution);
        }
    }

    public void releaseRects() {
        this.getLeaves();
        this.root.children = null;
    }

    public RectNode getRoot() {
        return this.root;
    }

    public void reset() {
        this.root = new RectNode(this.root.rect);
    }

    class RectNode {
        final SmallRect rect;
        private RectNode[] children;
        private final SmallRect[] childAreas;
        short filled = EMPTY;

        public RectNode(SmallRect rect) {
            this.rect = rect;
            int width = rect.width / 2;
            int height = rect.height / 2;
            if (rect.width > RectTree.this.minResolution) {
                this.childAreas = new SmallRect[4];
                this.childAreas[0] = new SmallRect(rect.x, rect.y, width, height);
                this.childAreas[1] = new SmallRect(rect.x + width, rect.y, width, height);
                this.childAreas[2] = new SmallRect(rect.x, rect.y + height, width, height);
                this.childAreas[3] = new SmallRect(rect.x + width, rect.y + height, width, height);
            } else {
                this.childAreas = null;
            }
        }

        private int getChildIndex(SmallRect r) {
            int index = 0;
            if (r.y >= this.childAreas[3].y) {
                index = r.x >= this.childAreas[3].x ? 3 : 2;
            } else if (r.x >= this.childAreas[1].x) {
                index = 1;
            }
            return index;
        }

        public boolean insert(SmallRect r, short id) {
            boolean filledChild;
            if (this.rect.width == RectTree.this.minResolution) {
                this.filled = id;
                return true;
            }
            int i = this.getChildIndex(r);
            if (this.children == null) {
                this.children = new RectNode[4];
            }
            if (this.children[i] == null) {
                this.children[i] = new RectNode(this.childAreas[i]);
            }
            if (filledChild = this.children[i].insert(r, id)) {
                HashSet<Short> ids = new HashSet<Short>();
                boolean filled = true;
                int j = 0;
                while (j < this.children.length) {
                    if (i != j) {
                        if (this.children[j] == null || this.children[j].filled == EMPTY) {
                            filled = false;
                            break;
                        }
                        ids.add(this.children[j].filled);
                    }
                    ++j;
                }
                if (filled) {
                    if (ids.size() == 1) {
                        this.filled = (Short)ids.iterator().next();
                        if (this.filled == BACKGROUND) {
                            this.children = null;
                        }
                    } else {
                        this.filled = MISC;
                    }
                }
                return filled;
            }
            return false;
        }

        public boolean isAvailable(SmallRect oRect) {
            if (this.filled >= MISC) {
                return false;
            }
            if (this.children == null) {
                return this.filled == EMPTY;
            }
            int i = this.getChildIndex(oRect);
            if (this.children[i] == null) {
                return true;
            }
            return this.children[i].isAvailable(oRect);
        }

        public short getWordId(int x, int y) {
            if (this.filled > BACKGROUND) {
                return this.filled;
            }
            if (this.children == null) {
                return this.filled;
            }
            int i = 0;
            while (i < this.childAreas.length) {
                if (this.childAreas[i].intersects(x, y, RectTree.this.minResolution, RectTree.this.minResolution) && this.children[i] != null) {
                    return this.children[i].getWordId(x, y);
                }
                ++i;
            }
            return EMPTY;
        }

        public short getWordId(Point position) {
            return this.getWordId(position.x, position.y);
        }
    }
}

