/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.swt.controls;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import org.eclipse.gef.fx.swt.controls.FXColorPicker;
import org.eclipse.gef.fx.swt.controls.FXControlAdapter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FXSimpleLinearGradientPicker
extends Composite {
    public static final String SIMPLE_LINEAR_GRADIENT_PROPERTY = "simpleLinearGradient";
    private ObjectProperty<LinearGradient> simpleLinearGradient = new SimpleObjectProperty((Object)this, "simpleLinearGradient");
    private FXColorPicker color1Picker;
    private FXColorPicker color2Picker;

    public static LinearGradient createSimpleLinearGradient(Color c1, Color c2) {
        Stop[] stops = new Stop[]{new Stop(0.0, c1), new Stop(1.0, c2)};
        return new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    public static boolean isSimpleLinearGradient(Paint paint) {
        if (paint instanceof LinearGradient) {
            return ((LinearGradient)paint).getStops().size() == 2;
        }
        return false;
    }

    public FXSimpleLinearGradientPicker(Composite parent, Color color1, Color color2) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        FXCanvas canvas = new FXCanvas((Composite)this, 0);
        HBox root = new HBox();
        root.setStyle("-fx-background-color: transparent;");
        VBox colorEditorsBox = new VBox();
        colorEditorsBox.setSpacing(5.0);
        root.getChildren().add((Object)colorEditorsBox);
        this.color1Picker = new FXColorPicker((Composite)canvas, color1);
        colorEditorsBox.getChildren().add(new FXControlAdapter<FXColorPicker>(this.color1Picker));
        this.color1Picker.colorProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                FXSimpleLinearGradientPicker.this.setSimpleLinearGradient(FXSimpleLinearGradientPicker.createSimpleLinearGradient(newValue, FXSimpleLinearGradientPicker.this.color2Picker.getColor()));
            }
        });
        this.color2Picker = new FXColorPicker((Composite)canvas, color2);
        colorEditorsBox.getChildren().add(new FXControlAdapter<FXColorPicker>(this.color2Picker));
        this.color2Picker.colorProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                FXSimpleLinearGradientPicker.this.setSimpleLinearGradient(FXSimpleLinearGradientPicker.createSimpleLinearGradient(FXSimpleLinearGradientPicker.this.color1Picker.getColor(), newValue));
            }
        });
        Scene scene = new Scene((Parent)root);
        org.eclipse.swt.graphics.Color backgroundColor = parent.getBackground();
        scene.setFill((Paint)Color.rgb((int)backgroundColor.getRed(), (int)backgroundColor.getGreen(), (int)backgroundColor.getBlue()));
        canvas.setScene(scene);
        this.setSimpleLinearGradient(FXSimpleLinearGradientPicker.createSimpleLinearGradient(color1, color2));
    }

    public LinearGradient getSimpleLinearGradient() {
        return (LinearGradient)this.simpleLinearGradient.get();
    }

    public void setSimpleLinearGradient(LinearGradient simpleLinearGradient) {
        if (!FXSimpleLinearGradientPicker.isSimpleLinearGradient((Paint)simpleLinearGradient)) {
            throw new IllegalArgumentException("Given value '" + simpleLinearGradient + "' is no simple linear gradient");
        }
        this.simpleLinearGradient.set((Object)simpleLinearGradient);
        List stops = simpleLinearGradient.getStops();
        if (!this.color1Picker.getColor().equals((Object)((Stop)stops.get(0)).getColor())) {
            this.color1Picker.setColor(((Stop)stops.get(0)).getColor());
        }
        if (!this.color2Picker.getColor().equals((Object)((Stop)stops.get(1)).getColor())) {
            this.color2Picker.setColor(((Stop)stops.get(1)).getColor());
        }
    }

    public Property<LinearGradient> simpleLinearGradientProperty() {
        return this.simpleLinearGradient;
    }
}

