/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.ZoomEvent;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IOnPinchSpreadHandler;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class PinchSpreadGesture
extends AbstractGesture {
    public static final Class<IOnPinchSpreadHandler> ON_PINCH_SPREAD_POLICY_KEY = IOnPinchSpreadHandler.class;
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new IdentityHashMap<IViewer, ChangeListener<Boolean>>();
    private Map<Scene, EventHandler<ZoomEvent>> zoomFilters = new IdentityHashMap<Scene, EventHandler<ZoomEvent>>();

    protected ChangeListener<Boolean> createFocusChangeListener(final IViewer viewer) {
        ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue == null || !newValue.booleanValue()) {
                    for (IOnPinchSpreadHandler iOnPinchSpreadHandler : PinchSpreadGesture.this.getActiveHandlers(viewer)) {
                        iOnPinchSpreadHandler.abortZoom();
                    }
                    PinchSpreadGesture.this.clearActiveHandlers(viewer);
                    PinchSpreadGesture.this.getDomain().closeExecutionTransaction(PinchSpreadGesture.this);
                }
            }
        };
        return viewerFocusChangeListener;
    }

    protected EventHandler<ZoomEvent> createZoomFilter(Scene scene) {
        return new EventHandler<ZoomEvent>(){
            private IViewer activeViewer;

            public void handle(ZoomEvent event) {
                if (ZoomEvent.ZOOM.equals(event.getEventType())) {
                    if (this.activeViewer == null) {
                        return;
                    }
                    for (IOnPinchSpreadHandler iOnPinchSpreadHandler : PinchSpreadGesture.this.getActiveHandlers(this.activeViewer)) {
                        iOnPinchSpreadHandler.zoom(event);
                    }
                } else if (ZoomEvent.ZOOM_STARTED.equals(event.getEventType())) {
                    if (!(event.getTarget() instanceof Node)) {
                        return;
                    }
                    IViewer iViewer = PartUtils.retrieveViewer(PinchSpreadGesture.this.getDomain(), (Node)event.getTarget());
                    if (iViewer == null) {
                        return;
                    }
                    this.activeViewer = iViewer;
                    if (!PinchSpreadGesture.this.getDomain().isExecutionTransactionOpen(PinchSpreadGesture.this)) {
                        PinchSpreadGesture.this.getDomain().openExecutionTransaction(PinchSpreadGesture.this);
                    }
                    EventTarget eventTarget = event.getTarget();
                    PinchSpreadGesture.this.setActiveHandlers(this.activeViewer, PinchSpreadGesture.this.getHandlerResolver().resolve(PinchSpreadGesture.this, eventTarget instanceof Node ? (Node)eventTarget : null, this.activeViewer, ON_PINCH_SPREAD_POLICY_KEY));
                    for (IOnPinchSpreadHandler iOnPinchSpreadHandler : PinchSpreadGesture.this.getActiveHandlers(iViewer)) {
                        iOnPinchSpreadHandler.startZoom(event);
                    }
                } else if (ZoomEvent.ZOOM_FINISHED.equals(event.getEventType())) {
                    if (this.activeViewer == null) {
                        return;
                    }
                    for (IOnPinchSpreadHandler iOnPinchSpreadHandler : PinchSpreadGesture.this.getActiveHandlers(this.activeViewer)) {
                        iOnPinchSpreadHandler.endZoom(event);
                    }
                    PinchSpreadGesture.this.clearActiveHandlers(this.activeViewer);
                    PinchSpreadGesture.this.getDomain().closeExecutionTransaction(PinchSpreadGesture.this);
                }
            }
        };
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        ChangeListener sceneListener = (exp, oldScene, newScene) -> {
            if (oldScene != null && this.getDomain().getViewers().values().stream().noneMatch(v -> v.getCanvas().getScene() == oldScene)) {
                this.unhookScene((Scene)oldScene);
            }
            if (newScene != null) {
                this.hookScene((Scene)newScene);
            }
        };
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = this.createFocusChangeListener(viewer);
            viewer.viewerFocusedProperty().addListener(viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            ReadOnlyObjectProperty sceneProperty = viewer.getCanvas().sceneProperty();
            sceneProperty.addListener(sceneListener);
            if (sceneProperty.get() == null) continue;
            sceneListener.changed((ObservableValue)sceneProperty, null, sceneProperty.get());
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : new ArrayList<Scene>(this.zoomFilters.keySet())) {
            this.unhookScene(scene);
        }
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        super.doDeactivate();
    }

    public List<? extends IOnPinchSpreadHandler> getActiveHandlers(IViewer viewer) {
        return super.getActiveHandlers(viewer);
    }

    private void hookScene(Scene scene) {
        if (this.zoomFilters.containsKey(scene)) {
            return;
        }
        EventHandler<ZoomEvent> zoomFilter = this.createZoomFilter(scene);
        scene.addEventFilter(ZoomEvent.ANY, zoomFilter);
        this.zoomFilters.put(scene, zoomFilter);
    }

    private void unhookScene(Scene scene) {
        scene.removeEventFilter(ZoomEvent.ANY, this.zoomFilters.remove(scene));
    }
}

