/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleStructures;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;
import org.eclipse.zest.layouts.interfaces.ContextListener;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.ExpandCollapseManager;
import org.eclipse.zest.layouts.interfaces.GraphStructureListener;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.LayoutListener;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.PruningListener;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class SimpleGraph
implements LayoutContext {
    Map<Object, SimpleNode> objectsToNodes = new LinkedHashMap<Object, SimpleNode>();
    List<SimpleRelationship> relationships = new ArrayList<SimpleRelationship>();
    LayoutAlgorithm algorithm;
    ExpandCollapseManager expandCollapseManager;
    EventListenerList listeners = new EventListenerList();
    DisplayIndependentRectangle bounds = new DisplayIndependentRectangle();

    public void addEntity(SimpleNode node) {
        this.objectsToNodes.put(node.getRealObject(), node);
    }

    public SimpleNode addObjectNode(Object object) {
        return this.objectsToNodes.computeIfAbsent(object, ignore -> new SimpleNode(object, this));
    }

    public void addObjectRelationship(SimpleNode sourceNode, SimpleNode destinationNode) {
        this.addObjectRelationship(sourceNode, destinationNode, true, 1);
    }

    public void addObjectRelationship(Object sourceObject, Object destinationObject, boolean bidirectional, int weight) {
        this.addObjectNode(sourceObject);
        this.addObjectNode(destinationObject);
        SimpleNode sourceNode = this.objectsToNodes.get(sourceObject);
        SimpleNode destinationNode = this.objectsToNodes.get(destinationObject);
        SimpleRelationship simpleRelationship = new SimpleRelationship(sourceNode, destinationNode, bidirectional, weight);
        this.relationships.add(simpleRelationship);
    }

    public void addRelationship(SimpleNode srcNode, SimpleNode destNode) {
        this.addRelationship(srcNode, destNode, true, 1);
    }

    public void addRelationship(SimpleNode srcNode, SimpleNode destNode, boolean bidirectional, int weight) {
        this.addEntity(srcNode);
        this.addEntity(destNode);
        SimpleRelationship rel = new SimpleRelationship(srcNode, destNode, bidirectional, weight);
        this.relationships.add(rel);
    }

    public void addRelationship(SimpleRelationship relationship) {
        this.relationships.add(relationship);
    }

    public SimpleNode[] getNodes() {
        return (SimpleNode[])this.objectsToNodes.values().toArray(SimpleNode[]::new);
    }

    public SimpleRelationship[] getConnections() {
        return (SimpleRelationship[])this.relationships.toArray(SimpleRelationship[]::new);
    }

    public SimpleRelationship[] getConnections(EntityLayout layoutEntity1, EntityLayout layoutEntity2) {
        ArrayList<SimpleRelationship> relationships = new ArrayList<SimpleRelationship>();
        for (SimpleRelationship relationship : this.relationships) {
            if (relationship.getSource() != layoutEntity1 || relationship.getTarget() != layoutEntity2) continue;
            relationships.add(relationship);
        }
        return (SimpleRelationship[])relationships.toArray(SimpleRelationship[]::new);
    }

    public void setBounds(double x, double y, double width, double height) {
        this.bounds.x = x;
        this.bounds.y = y;
        this.bounds.width = width;
        this.bounds.height = height;
    }

    public DisplayIndependentRectangle getBounds() {
        return this.bounds;
    }

    public boolean isBoundsExpandable() {
        return false;
    }

    public SubgraphLayout[] getSubgraphs() {
        return new SubgraphLayout[0];
    }

    public SubgraphLayout createSubgraph(NodeLayout[] nodes) {
        throw new UnsupportedOperationException();
    }

    public boolean isPruningEnabled() {
        return false;
    }

    public boolean isBackgroundLayoutEnabled() {
        return false;
    }

    public void flushChanges(boolean animationHint) {
    }

    public void setMainLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public LayoutAlgorithm getMainLayoutAlgorithm() {
        return this.algorithm;
    }

    public void setExpandCollapseManager(ExpandCollapseManager expandCollapseManager) {
        this.expandCollapseManager = expandCollapseManager;
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.expandCollapseManager;
    }

    public void addLayoutListener(LayoutListener listener) {
        this.listeners.addListener(LayoutListener.class, (Object)listener);
    }

    public void removeLayoutListener(LayoutListener listener) {
        this.listeners.removeListener(LayoutListener.class, (Object)listener);
    }

    public void addGraphStructureListener(GraphStructureListener listener) {
        this.listeners.addListener(GraphStructureListener.class, (Object)listener);
    }

    public void removeGraphStructureListener(GraphStructureListener listener) {
        this.listeners.removeListener(GraphStructureListener.class, (Object)listener);
    }

    public void addContextListener(ContextListener listener) {
        this.listeners.addListener(ContextListener.class, (Object)listener);
    }

    public void removeContextListener(ContextListener listener) {
        this.listeners.removeListener(ContextListener.class, (Object)listener);
    }

    public void addPruningListener(PruningListener listener) {
        this.listeners.addListener(PruningListener.class, (Object)listener);
    }

    public void removePruningListener(PruningListener listener) {
        this.listeners.removeListener(PruningListener.class, (Object)listener);
    }

    public SimpleNode[] getEntities() {
        return this.getNodes();
    }
}

