/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.commands.ExampleTextCommand;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class CompoundEditCommand
extends ExampleTextCommand
implements AppendableCommand {
    private ModelLocation beginLocation;
    private List<MiniEdit> edits = new ArrayList<MiniEdit>();
    private ModelLocation endLocation;
    private List<MiniEdit> pending;

    public CompoundEditCommand(String label) {
        super(label);
    }

    public void execute() {
        this.executePending();
    }

    public boolean canExecute() {
        return this.canExecutePending();
    }

    @Override
    public boolean canExecutePending() {
        if (this.pending == null || this.pending.isEmpty()) {
            return false;
        }
        return this.pending.stream().noneMatch(edit -> edit == null || !edit.canApply());
    }

    @Override
    public void executePending() {
        Assert.isNotNull(this.pending);
        this.pending.forEach(MiniEdit::apply);
        this.edits.addAll(this.pending);
        this.pending = null;
    }

    @Override
    public void flushPending() {
        this.pending = null;
    }

    @Override
    public SelectionRange getExecuteSelectionRange(GraphicalTextViewer viewer) {
        ModelLocation loc = this.edits.get(this.edits.size() - 1).getResultingLocation();
        if (loc == null) {
            return this.getUndoSelectionRange(viewer);
        }
        return new SelectionRange(CompoundEditCommand.lookupModel(viewer, loc.model), loc.offset);
    }

    @Override
    public SelectionRange getRedoSelectionRange(GraphicalTextViewer viewer) {
        return this.getExecuteSelectionRange(viewer);
    }

    @Override
    public SelectionRange getUndoSelectionRange(GraphicalTextViewer viewer) {
        TextEditPart begin = CompoundEditCommand.lookupModel(viewer, this.beginLocation.model);
        if (this.endLocation == null) {
            return new SelectionRange(begin, this.beginLocation.offset);
        }
        TextEditPart end = CompoundEditCommand.lookupModel(viewer, this.endLocation.model);
        return new SelectionRange(begin, this.beginLocation.offset, end, this.endLocation.offset);
    }

    public void pendEdit(MiniEdit edit) {
        if (this.pending == null) {
            this.pending = new ArrayList<MiniEdit>(2);
        }
        this.pending.add(edit);
    }

    public void redo() {
        this.edits.forEach(MiniEdit::reapply);
    }

    public void setEndLocation(ModelLocation endLocation) {
        this.endLocation = endLocation;
    }

    public void setBeginLocation(ModelLocation startLocation) {
        this.beginLocation = startLocation;
    }

    public void undo() {
        int i = this.edits.size() - 1;
        while (i >= 0) {
            MiniEdit edit = this.edits.get(i);
            edit.rollback();
            --i;
        }
    }
}

