/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.text;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowAdapter;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TextSurroundingFigureExample {
    public static void main(String[] args) {
        Display d = Display.getDefault();
        Shell shell = new Shell(d);
        org.eclipse.swt.custom.StackLayout layout = new org.eclipse.swt.custom.StackLayout();
        shell.setLayout((Layout)layout);
        FigureCanvas canvas = new FigureCanvas((Composite)shell);
        layout.topControl = canvas;
        canvas.getViewport().setContentsTracksWidth(true);
        FlowPage page = new FlowPage();
        TextSurroundingFigureExample.populatePage(page);
        canvas.setContents((IFigure)page);
        shell.setSize(300, 300);
        shell.open();
        while (!shell.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
    }

    private static void populatePage(FlowPage page) {
        page.setOrientation(0x2000000);
        TextFlow textFlow1 = new TextFlow();
        textFlow1.setText("This is the text on the left side, and \u0634\u0637\u0635.  There has to be a lot of text here to see the first proxy wrap.  So, here we go.");
        page.add((IFigure)textFlow1);
        FlowAdapter proxy1 = new FlowAdapter();
        proxy1.setBorder((Border)new LineBorder(ColorConstants.orange, 3));
        proxy1.setLayoutManager((LayoutManager)new ToolbarLayout());
        RoundedRectangle rect = new RoundedRectangle();
        rect.setCornerDimensions(new Dimension(25, 25));
        rect.setBackgroundColor(ColorConstants.green);
        rect.setForegroundColor(ColorConstants.black);
        rect.setPreferredSize(100, 40);
        proxy1.add((IFigure)rect);
        Triangle shape = new Triangle();
        shape.setBackgroundColor(ColorConstants.red);
        shape.setForegroundColor(ColorConstants.black);
        shape.setPreferredSize(80, 80);
        proxy1.add((IFigure)shape);
        shape = new Ellipse();
        shape.setBackgroundColor(ColorConstants.blue);
        shape.setForegroundColor(ColorConstants.black);
        shape.setPreferredSize(70, 70);
        proxy1.add((IFigure)shape);
        page.add((IFigure)proxy1);
        TextFlow textFlow2 = new TextFlow();
        textFlow2.setText("This is the right side text.");
        page.add((IFigure)textFlow2);
        FlowAdapter proxy2 = new FlowAdapter();
        proxy2.setBorder(proxy1.getBorder());
        proxy2.setLayoutManager((LayoutManager)new StackLayout());
        TextFlow flow = new TextFlow();
        flow.setText("Text inside a proxy figure with BiDi: \u0634\u0637\u0635 \u0639\u0633\u0640 \u0632\u0638\u0635.");
        FlowPage innerPage = new FlowPage();
        innerPage.setOrientation(0x4000000);
        innerPage.add((IFigure)flow);
        proxy2.add((IFigure)innerPage);
        page.add((IFigure)proxy2);
    }
}

