/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.gef.examples.text.edit.ExampleTreePart;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.ModelElement;
import org.eclipse.gef.examples.text.model.Style;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ContainerTreePart
extends ExampleTreePart {
    public ContainerTreePart(Container model) {
        this.setModel(model);
    }

    protected List<ModelElement> getModelChildren() {
        return this.getModel().getChildren();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("children")) {
            this.refreshChildren();
        }
    }

    public Container getModel() {
        return (Container)super.getModel();
    }

    /*
     * WARNING - void declaration
     */
    protected void refreshChildren() {
        super.refreshChildren();
        Widget widget = this.getWidget();
        if (widget instanceof TreeItem) {
            void item;
            TreeItem treeItem = (TreeItem)widget;
            TreeItem cfr_ignored_0 = (TreeItem)widget;
            item.setExpanded(true);
        }
    }

    protected void refreshVisuals() {
        StringBuffer label = new StringBuffer();
        switch (this.getModel().getType()) {
            case 1: {
                label.append("<bullet>");
                break;
            }
            case 2: {
                label.append("<comment>");
                break;
            }
            case 3: {
                label.append("<import declarations>");
                break;
            }
            case 6: {
                Style style = this.getModel().getStyle();
                if (style.isSet("fontSize")) {
                    label.append("<FONT SIZE>");
                }
                if (style.isSet("bold")) {
                    label.append("<B>");
                }
                if (style.isSet("italics")) {
                    label.append("<I>");
                }
                if (style.isSet("underline")) {
                    label.append("<U>");
                }
                if (!style.isSet("font")) break;
                label.append("<FONT>");
                break;
            }
            case 4: {
                label.append("Paragraph");
                break;
            }
            default: {
                label.append("Unknown container");
            }
        }
        this.setWidgetText(label.toString());
    }
}

