/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicResizableEditPolicy;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.commands.AddCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.CloneCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.CreateCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.ReorderPartCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class LogicFlowEditPolicy
extends FlowLayoutEditPolicy {
    protected Command getCloneCommand(ChangeBoundsRequest request) {
        CloneCommand clone = new CloneCommand();
        clone.setParent((LogicDiagram)this.getHost().getModel());
        EditPart after = this.getInsertionReference((Request)request);
        int index = this.getHost().getChildren().indexOf(after);
        Iterator i = request.getEditParts().iterator();
        GraphicalEditPart currPart = null;
        while (i.hasNext()) {
            currPart = (GraphicalEditPart)i.next();
            clone.addPart((LogicSubpart)currPart.getModel(), index++);
        }
        return clone;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        AddCommand command = new AddCommand();
        command.setChild((LogicSubpart)child.getModel());
        command.setParent((LogicFlowContainer)this.getHost().getModel());
        int index = this.getHost().getChildren().indexOf(after);
        command.setIndex(index);
        return command;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        LogicResizableEditPolicy policy = new LogicResizableEditPolicy();
        policy.setResizeDirections(0);
        return policy;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        LogicSubpart childModel = (LogicSubpart)child.getModel();
        LogicDiagram parentModel = (LogicDiagram)this.getHost().getModel();
        int oldIndex = this.getHost().getChildren().indexOf(child);
        int newIndex = this.getHost().getChildren().indexOf(after);
        if (newIndex > oldIndex) {
            --newIndex;
        }
        return new ReorderPartCommand(childModel, parentModel, newIndex);
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateCommand command = new CreateCommand();
        EditPart after = this.getInsertionReference((Request)request);
        command.setChild((LogicSubpart)request.getNewObject());
        command.setParent((LogicFlowContainer)this.getHost().getModel());
        int index = this.getHost().getChildren().indexOf(after);
        command.setIndex(index);
        return command;
    }
}

