/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.examples.tree.AbstractBranchLayout;
import org.eclipse.draw2d.examples.tree.Animation;
import org.eclipse.draw2d.examples.tree.HangingLayout;
import org.eclipse.draw2d.examples.tree.NormalLayout;
import org.eclipse.draw2d.examples.tree.TreeLayout;
import org.eclipse.draw2d.examples.tree.TreeRoot;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class TreeBranch
extends Figure {
    public static final int STYLE_HANGING = 1;
    public static final int STYLE_NORMAL = 2;
    int aligment = 2;
    private AnimatingLayer contents = new AnimatingLayer();
    boolean expanded = true;
    private IFigure node;
    private int style;

    public TreeBranch(IFigure title) {
        this(title, 2);
    }

    public TreeBranch(IFigure title, int style) {
        this.setStyle(style);
        if (title.getBorder() == null) {
            title.setBorder((Border)new LineBorder(ColorConstants.gray, 2));
        }
        this.node = title;
        this.add((IFigure)this.contents);
        this.add(title);
    }

    public void animationReset(Rectangle bounds) {
        this.contents.setBounds(bounds);
        Rectangle r = this.node.getBounds();
        int dx = bounds.x + bounds.width / 2 - r.x - r.width / 2;
        int dy = bounds.y + bounds.height / 2 - r.y - r.height / 2;
        this.node.translate(dx, dy);
        this.revalidate();
        this.contents.getChildren().forEach(child -> {
            child.setBounds(bounds);
            child.animationReset(bounds);
        });
    }

    public void collapse() {
        if (!this.expanded) {
            return;
        }
        TreeBranch root = this;
        Viewport port = null;
        Point viewportStart = null;
        while (root.getParent() != null) {
            if (root instanceof Viewport) {
                port = (Viewport)root;
            }
            root = root.getParent();
        }
        viewportStart = port.getViewLocation();
        Point nodeStart = this.node.getBounds().getLocation();
        this.setExpanded(false);
        root.validate();
        this.setExpanded(true);
        this.animationReset(this.getNodeBounds());
        Animation.mark(this.getNode());
        Animation.captureLayout((IFigure)this.getRoot());
        Animation.swap();
        Animation.trackLocation = nodeStart;
        root.validate();
        port.setViewLocation(viewportStart);
        while (Animation.step()) {
            this.getUpdateManager().performUpdate();
        }
        Animation.end();
        this.setExpanded(false);
    }

    public boolean containsPoint(int x, int y) {
        return this.node.containsPoint(x, y) || this.contents.containsPoint(x, y);
    }

    public void expand() {
        if (this.expanded) {
            return;
        }
        this.setExpanded(true);
        this.animationReset(this.getNodeBounds());
        Animation.mark(this.getNode());
        Animation.captureLayout((IFigure)this.getRoot());
        while (Animation.step()) {
            this.getUpdateManager().performUpdate();
        }
        Animation.end();
    }

    public int getAlignment() {
        return this.aligment;
    }

    protected AbstractBranchLayout getBranchLayout() {
        return (AbstractBranchLayout)this.getLayoutManager();
    }

    public void addBranch(TreeBranch branch) {
        this.contents.add((IFigure)branch);
    }

    public IFigure getContentsPane() {
        return this.contents;
    }

    public List<TreeBranch> getSubtrees() {
        return this.contents.getChildren();
    }

    public int[] getContourLeft() {
        return this.getBranchLayout().getContourLeft();
    }

    public int[] getContourRight() {
        return this.getBranchLayout().getContourRight();
    }

    public int getDepth() {
        return this.getBranchLayout().getDepth();
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        if (!Animation.PLAYBACK) {
            this.validate();
        }
        return super.getMinimumSize(wHint, hHint);
    }

    public IFigure getNode() {
        return this.node;
    }

    public Rectangle getNodeBounds() {
        return this.node.getBounds();
    }

    public int[] getPreferredRowHeights() {
        return this.getBranchLayout().getPreferredRowHeights();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (!Animation.PLAYBACK) {
            this.validate();
        }
        return super.getPreferredSize(wHint, hHint);
    }

    public TreeRoot getRoot() {
        return ((TreeBranch)this.getParent().getParent()).getRoot();
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.isExpanded()) {
            this.getBranchLayout().paintLines(graphics);
        }
    }

    public void setAlignment(int value) {
        this.aligment = value;
        this.revalidate();
    }

    public void setExpanded(boolean b) {
        if (this.expanded == b) {
            return;
        }
        this.expanded = b;
        this.contents.setVisible(b);
        this.revalidate();
    }

    public void setRowHeights(int[] heights, int offset) {
        this.getBranchLayout().setRowHeights(heights, offset);
    }

    public void setStyle(int style) {
        if (this.style == style) {
            return;
        }
        this.style = style;
        switch (style) {
            case 1: {
                this.setLayoutManager((LayoutManager)new HangingLayout(this));
                break;
            }
            default: {
                this.setLayoutManager((LayoutManager)new NormalLayout(this));
                this.contents.setLayoutManager((LayoutManager)new TreeLayout());
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int level) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < level) {
            builder.append("  ");
            ++i;
        }
        builder.append(this.getChildren().get(1));
        builder.append("\n");
        int childrenlevel = level + 1;
        this.contents.getChildren().forEach(child -> {
            StringBuilder stringBuilder2 = builder.append(child.toString(childrenlevel));
        });
        return builder.toString();
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        if (this.style == 1) {
            ToolbarLayout layout = new ToolbarLayout(!this.getRoot().isHorizontal()){

                public void layout(IFigure parent) {
                    Animation.recordInitialState(parent);
                    if (Animation.playbackState(parent)) {
                        return;
                    }
                    super.layout(parent);
                }
            };
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            this.contents.setLayoutManager((LayoutManager)layout);
        }
        this.repaint();
        super.validate();
    }

    class AnimatingLayer
    extends Layer {
        AnimatingLayer() {
        }

        public void setBounds(Rectangle rect) {
            boolean translate;
            int x = this.bounds.x;
            int y = this.bounds.y;
            boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
            boolean bl = translate = rect.x != x || rect.y != y;
            if (this.isVisible() && (resize || translate)) {
                this.erase();
            }
            if (translate) {
                int dx = rect.x - x;
                int dy = rect.y - y;
                this.primTranslate(dx, dy);
            }
            this.bounds.width = rect.width;
            this.bounds.height = rect.height;
            if (resize || translate) {
                this.fireMoved();
                this.repaint();
            }
        }

        public List<TreeBranch> getChildren() {
            return super.getChildren();
        }
    }
}

