/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.layouts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class ToolbarLayoutExample
extends AbstractExample {
    ToolbarLayout layout;
    Shape ellipse;
    Shape rect;
    Shape roundRect;
    Shape ellipse2;
    Shape rect2;

    public static void main(String[] args) {
        new ToolbarLayoutExample().run();
    }

    @Override
    protected IFigure createContents() {
        Figure container = new Figure();
        container.setBorder((Border)new LineBorder());
        this.layout = new ToolbarLayout(true);
        container.setLayoutManager((LayoutManager)this.layout);
        this.ellipse = new Ellipse();
        this.ellipse.setBackgroundColor(ColorConstants.blue);
        this.ellipse.setSize(60, 40);
        container.add((IFigure)this.ellipse);
        this.rect = new RectangleFigure();
        this.rect.setBackgroundColor(ColorConstants.red);
        this.rect.setSize(30, 70);
        container.add((IFigure)this.rect);
        this.roundRect = new RoundedRectangle();
        this.roundRect.setBackgroundColor(ColorConstants.yellow);
        this.roundRect.setSize(90, 30);
        container.add((IFigure)this.roundRect);
        this.rect2 = new RectangleFigure();
        this.rect2.setBackgroundColor(ColorConstants.gray);
        this.rect2.setSize(50, 80);
        container.add((IFigure)this.rect2);
        this.ellipse2 = new Ellipse();
        this.ellipse2.setBackgroundColor(ColorConstants.green);
        this.ellipse2.setSize(50, 50);
        container.add((IFigure)this.ellipse2);
        return container;
    }

    @Override
    protected void hookShell(final Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(1040));
        composite.setLayout((Layout)new GridLayout());
        Button horizontal = new Button(composite, 32);
        horizontal.setText("Horizontal");
        horizontal.setSelection(true);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolbarLayoutExample.this.layout.setVertical(ToolbarLayoutExample.this.layout.isHorizontal());
                if (ToolbarLayoutExample.this.layout.getStretchMinorAxis()) {
                    ToolbarLayoutExample.this.resetShapes();
                }
                ToolbarLayoutExample.this.getContents().revalidate();
                shell.layout(true);
            }
        });
        Button stretch = new Button(composite, 32);
        stretch.setText("Stretch Minor Axis");
        stretch.setSelection(false);
        stretch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolbarLayoutExample.this.layout.setStretchMinorAxis(!ToolbarLayoutExample.this.layout.getStretchMinorAxis());
                ToolbarLayoutExample.this.resetShapes();
                ToolbarLayoutExample.this.getContents().revalidate();
                shell.layout(true);
            }
        });
        Group major = new Group(composite, 0);
        major.setLayout((Layout)new FillLayout(512));
        major.setText("Minor Axis");
        Button left = new Button((Composite)major, 16);
        left.setText("Top/Left");
        left.setSelection(true);
        left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolbarLayoutExample.this.layout.setMinorAlignment(1);
                ToolbarLayoutExample.this.getContents().revalidate();
            }
        });
        Button center = new Button((Composite)major, 16);
        center.setText("Middle/Center");
        center.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolbarLayoutExample.this.layout.setMinorAlignment(0);
                ToolbarLayoutExample.this.getContents().revalidate();
            }
        });
        Button right = new Button((Composite)major, 16);
        right.setText("Buttom/Right");
        right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolbarLayoutExample.this.layout.setMinorAlignment(2);
                ToolbarLayoutExample.this.getContents().revalidate();
            }
        });
        final Scale spacing = new Scale((Composite)major, 0);
        spacing.setMinimum(0);
        spacing.setMaximum(20);
        spacing.setSelection(5);
        spacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolbarLayoutExample.this.layout.setSpacing(spacing.getSelection());
                ToolbarLayoutExample.this.getContents().revalidate();
            }
        });
        Label spacingLabel = new Label((Composite)major, 0x1000000);
        spacingLabel.setText("Spacing");
    }

    private void resetShapes() {
        this.rect.setSize(30, 70);
        this.rect2.setSize(50, 80);
        this.roundRect.setSize(90, 30);
        this.ellipse.setSize(60, 40);
        this.ellipse2.setSize(50, 50);
    }
}

