/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.cg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;

public class ObstructionExample
extends AbstractExample {
    static ShortestPathRouter router = new ShortestPathRouter();
    static Map<IFigure, Rectangle> obstacleMap = new HashMap<IFigure, Rectangle>();
    static List<Path> paths = new ArrayList<Path>();

    @Override
    protected IFigure createContents() {
        TestFigure f = new TestFigure();
        f.setPreferredSize(900, 700);
        return f;
    }

    public static void main(String[] args) {
        new ObstructionExample().run();
    }

    static class DragFigure
    extends RectangleFigure {
        private static Dimension offset = new Dimension();

        public DragFigure() {
            this.setBackgroundColor(ColorConstants.green);
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent event) {
                    event.consume();
                    offset.setWidth(event.x - this.getLocation().x());
                    offset.setHeight(event.y - this.getLocation().y());
                }

                public void mouseReleased(MouseEvent event) {
                    offset.setWidth(0);
                    offset.setHeight(0);
                    if (event.button == 3) {
                        this.getParent().remove((IFigure)this);
                    }
                }
            });
            this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent event) {
                    Rectangle rect = this.getBounds().getCopy();
                    rect.setX(event.x - offset.width());
                    rect.setY(event.y - offset.height());
                    router.updateObstacle(obstacleMap.get((Object)this), rect);
                    obstacleMap.put((IFigure)this, rect);
                    this.setBounds(rect);
                    this.getParent().repaint();
                }
            });
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Rectangle b = this.getBounds();
            Point p = b.getCenter().translate(-22, -15);
            graphics.drawString("y:" + b.y() + "h:" + b.height(), p);
            p.setY(p.y() + 12);
            graphics.drawString("x:" + b.x() + "w:" + b.width(), p);
        }
    }

    static class EllipseDragFigure
    extends Ellipse {
        protected EllipseDragFigure oFigure;
        protected boolean isSource;
        protected Path path;
        private static Dimension offset = new Dimension();

        public EllipseDragFigure(boolean isItSource) {
            this.isSource = isItSource;
            this.setBackgroundColor(ColorConstants.darkBlue);
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent event) {
                    event.consume();
                    offset.setWidth(event.x - this.getLocation().x());
                    offset.setHeight(event.y - this.getLocation().y());
                }

                public void mouseReleased(MouseEvent event) {
                    offset.setWidth(0);
                    offset.setHeight(0);
                    if (event.button == 2) {
                        this.getParent().remove((IFigure)this);
                    }
                }
            });
            this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent event) {
                    Rectangle rect = this.getBounds().getCopy();
                    rect.setX(event.x - offset.width());
                    rect.setY(event.y - offset.height());
                    this.setBounds(rect);
                    router.removePath(path);
                    paths.remove(path);
                    path = isSource ? new Path(this.getBounds().getCenter(), oFigure.getBounds().getCenter()) : new Path(oFigure.getBounds().getCenter(), this.getBounds().getCenter());
                    router.addPath(path);
                    paths.add(path);
                    oFigure.path = path;
                    this.getParent().repaint();
                }
            });
        }

        public void addOtherFigure(EllipseDragFigure figure) {
            this.oFigure = figure;
        }

        public EllipseDragFigure getOtherFigure() {
            return this.oFigure;
        }
    }

    class TestFigure
    extends Figure {
        private static final int INITAL_OBSTACLE_COUNT = 5;
        Map obstacleMap = new HashMap();
        boolean showSegs = false;

        public TestFigure() {
            router = new ShortestPathRouter();
            this.addMouseListener((MouseListener)new MouseListener.Stub(){
                private EllipseDragFigure figure;
                private Point pPoint;

                public void mousePressed(MouseEvent event) {
                    event.consume();
                    this.pPoint = event.getLocation();
                }

                public void mouseReleased(MouseEvent event) {
                    if (event.button == 1) {
                        if (Math.abs(this.pPoint.x() - event.getLocation().x()) > 10) {
                            DragFigure f = new DragFigure();
                            f.setBounds(new Rectangle(this.pPoint, event.getLocation()));
                            TestFigure.this.add((IFigure)f);
                        }
                    } else if (event.button == 3) {
                        if (this.figure != null) {
                            EllipseDragFigure eFigure = new EllipseDragFigure(false);
                            eFigure.setBounds(new Rectangle(event.getLocation().x() - 10, event.getLocation().y() - 10, 20, 20));
                            this.figure.addOtherFigure(eFigure);
                            eFigure.addOtherFigure(this.figure);
                            TestFigure.this.add((IFigure)eFigure);
                            this.figure = null;
                        } else {
                            EllipseDragFigure eFigure = new EllipseDragFigure(true);
                            eFigure.setBounds(new Rectangle(event.getLocation().x() - 10, event.getLocation().y() - 10, 20, 20));
                            TestFigure.this.add((IFigure)eFigure);
                            this.figure = eFigure;
                        }
                    } else {
                        TestFigure.this.showSegs = !TestFigure.this.showSegs;
                    }
                    TestFigure.this.getParent().repaint();
                }
            });
            this.createInitialObstacles();
        }

        private final void createInitialObstacles() {
            Random r = new Random(0L);
            int rowSize = (int)Math.sqrt(5.0);
            int i = 0;
            while (i < 5) {
                DragFigure f = new DragFigure();
                Rectangle bounds = new Rectangle(i / rowSize * 101 + i % 3 * 10 + 100, i % rowSize * 101 + i % 7 * 6, 50, 80 + (int)(r.nextDouble() * 10.0));
                f.setBounds(bounds);
                this.add((IFigure)f);
                ++i;
            }
        }

        protected void paintBorder(Graphics g) {
            router.solve();
            g.setLineWidth(1);
            g.setForegroundColor(ColorConstants.blue);
            g.setBackgroundColor(ColorConstants.button);
            paths.forEach(p -> {
                PointList pList = p.getPoints();
                int i = 1;
                while (i < pList.size()) {
                    g.drawLine(pList.getPoint(i - 1), pList.getPoint(i));
                    ++i;
                }
            });
        }

        public void add(IFigure figure, Object constraint, int index) {
            if (figure instanceof DragFigure) {
                obstacleMap.put(figure, figure.getBounds());
                router.addObstacle(figure.getBounds());
            }
            if (figure instanceof EllipseDragFigure) {
                this.handleAddEllipseDragFigure((EllipseDragFigure)figure);
            }
            super.add(figure, constraint, index);
        }

        private void handleAddEllipseDragFigure(EllipseDragFigure figure) {
            EllipseDragFigure otherFigure = figure.getOtherFigure();
            if (otherFigure != null) {
                Path path = new Path(otherFigure.getBounds().getCenter(), figure.getBounds().getCenter());
                router.addPath(path);
                paths.add(path);
                otherFigure.path = path;
                figure.path = path;
            }
        }

        public void remove(IFigure figure) {
            if (figure instanceof DragFigure) {
                router.removeObstacle(obstacleMap.remove(figure));
            }
            if (figure instanceof EllipseDragFigure) {
                this.handleRemoveEllipseDragFigure((EllipseDragFigure)figure);
            }
            super.remove(figure);
            this.repaint();
        }

        private void handleRemoveEllipseDragFigure(EllipseDragFigure figure) {
            EllipseDragFigure otherFigure = figure.getOtherFigure();
            if (otherFigure != null) {
                this.getParent().remove((IFigure)otherFigure);
                router.removePath(figure.path);
                paths.remove(figure.path);
            }
        }
    }
}

