/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.parts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class GraphAnimation {
    static final long DURATION = 230L;
    static long current;
    static double progress;
    static long start;
    static long finish;
    static Viewport viewport;
    static boolean PLAYBACK;
    static boolean RECORDING;
    static Map initialStates;
    static Map finalStates;

    static {
        start = -1L;
    }

    static void end() {
        for (IFigure f : initialStates.keySet()) {
            f.revalidate();
            f.setVisible(true);
        }
        initialStates = null;
        finalStates = null;
        PLAYBACK = false;
        viewport = null;
    }

    /*
     * Unable to fully structure code
     */
    static boolean captureLayout(IFigure root) {
        GraphAnimation.RECORDING = true;
        while (!(root instanceof Viewport)) {
            root = root.getParent();
        }
        GraphAnimation.viewport = (Viewport)root;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        GraphAnimation.initialStates = new HashMap<K, V>();
        GraphAnimation.finalStates = new HashMap<K, V>();
        root.validate();
        iter = GraphAnimation.initialStates.keySet().iterator();
        if (iter.hasNext()) ** GOTO lbl17
        GraphAnimation.RECORDING = false;
        return false;
lbl-1000:
        // 1 sources

        {
            GraphAnimation.recordFinalState((IFigure)iter.next());
lbl17:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl18:
        // 1 sources

        GraphAnimation.start = System.currentTimeMillis();
        GraphAnimation.finish = GraphAnimation.start + 230L;
        GraphAnimation.current = GraphAnimation.start + 20L;
        GraphAnimation.RECORDING = false;
        GraphAnimation.PLAYBACK = true;
        return true;
    }

    static boolean playbackState(Connection conn) {
        if (!PLAYBACK) {
            return false;
        }
        PointList list1 = (PointList)initialStates.get(conn);
        PointList list2 = (PointList)finalStates.get(conn);
        if (list1 == null) {
            conn.setVisible(false);
            return true;
        }
        if (list1.size() == list2.size()) {
            Point pt1 = new Point();
            Point pt2 = new Point();
            PointList points = conn.getPoints();
            points.removeAllPoints();
            int i = 0;
            while (i < list1.size()) {
                list1.getPoint(pt2, i);
                list2.getPoint(pt1, i);
                pt1.x = (int)Math.round((double)pt1.x * progress + (1.0 - progress) * (double)pt2.x);
                pt1.y = (int)Math.round((double)pt1.y * progress + (1.0 - progress) * (double)pt2.y);
                points.addPoint(pt1);
                ++i;
            }
            conn.setPoints(points);
        }
        return true;
    }

    static boolean playbackState(IFigure container) {
        if (!PLAYBACK) {
            return false;
        }
        for (IFigure child : container.getChildren()) {
            Rectangle rect1 = (Rectangle)initialStates.get(child);
            Rectangle rect2 = (Rectangle)finalStates.get(child);
            if (rect2 == null) continue;
            child.setBounds(new Rectangle((int)Math.round(progress * (double)rect2.x + (1.0 - progress) * (double)rect1.x), (int)Math.round(progress * (double)rect2.y + (1.0 - progress) * (double)rect1.y), (int)Math.round(progress * (double)rect2.width + (1.0 - progress) * (double)rect1.width), (int)Math.round(progress * (double)rect2.height + (1.0 - progress) * (double)rect1.height)));
        }
        return true;
    }

    static void recordFinalState(Connection conn) {
        PointList points1 = (PointList)initialStates.get(conn);
        PointList points2 = conn.getPoints().getCopy();
        if (points1 != null && points1.size() != points2.size()) {
            Point p = new Point();
            Point q = new Point();
            int size1 = points1.size() - 1;
            int size2 = points2.size() - 1;
            int i1 = size1;
            int i2 = size2;
            double current1 = 1.0;
            double current2 = 1.0;
            double prev1 = 1.0;
            double prev2 = 1.0;
            while (i1 > 0 || i2 > 0) {
                if (Math.abs(current1 - current2) < 0.1 && i1 > 0 && i2 > 0) {
                    prev1 = current1;
                    prev2 = current2;
                    current1 = (double)(--i1) / (double)size1;
                    current2 = (double)(--i2) / (double)size2;
                    continue;
                }
                if (current1 < current2) {
                    points1.getPoint(p, i1);
                    points1.getPoint(q, i1 + 1);
                    p.x = (int)(((double)q.x * (current2 - current1) + (double)p.x * (prev1 - current2)) / (prev1 - current1));
                    p.y = (int)(((double)q.y * (current2 - current1) + (double)p.y * (prev1 - current2)) / (prev1 - current1));
                    points1.insertPoint(p, i1 + 1);
                    prev1 = prev2 = current2;
                    current2 = (double)(--i2) / (double)size2;
                    continue;
                }
                points2.getPoint(p, i2);
                points2.getPoint(q, i2 + 1);
                p.x = (int)(((double)q.x * (current1 - current2) + (double)p.x * (prev2 - current1)) / (prev2 - current2));
                p.y = (int)(((double)q.y * (current1 - current2) + (double)p.y * (prev2 - current1)) / (prev2 - current2));
                points2.insertPoint(p, i2 + 1);
                prev2 = prev1 = current1;
                current1 = (double)(--i1) / (double)size1;
            }
        }
        finalStates.put(conn, points2);
    }

    static void recordFinalState(IFigure child) {
        if (child instanceof Connection) {
            GraphAnimation.recordFinalState((Connection)child);
            return;
        }
        Rectangle rect2 = child.getBounds().getCopy();
        Rectangle rect1 = (Rectangle)initialStates.get(child);
        if (rect1.isEmpty()) {
            rect1.x = rect2.x;
            rect1.y = rect2.y;
            rect1.width = rect2.width;
        }
        finalStates.put(child, rect2);
    }

    static void recordInitialState(Connection connection) {
        if (!RECORDING) {
            return;
        }
        PointList points = connection.getPoints().getCopy();
        if (points.size() == 2 && points.getPoint(0).equals((Object)Point.SINGLETON.setLocation(0, 0)) && points.getPoint(1).equals((Object)Point.SINGLETON.setLocation(100, 100))) {
            initialStates.put(connection, null);
        } else {
            initialStates.put(connection, points);
        }
    }

    static void recordInitialState(IFigure container) {
        if (!RECORDING) {
            return;
        }
        for (IFigure child : container.getChildren()) {
            initialStates.put(child, child.getBounds().getCopy());
        }
    }

    static void swap() {
        Map temp = finalStates;
        finalStates = initialStates;
        initialStates = temp;
    }

    static boolean step() {
        current = System.currentTimeMillis() + 30L;
        progress = (double)(current - start) / (double)(finish - start);
        progress = Math.min(progress, 0.999);
        Iterator iter = initialStates.keySet().iterator();
        while (iter.hasNext()) {
            ((IFigure)iter.next()).revalidate();
        }
        viewport.validate();
        return current < finish;
    }
}

