/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gef.examples.text.model.ModelElement;
import org.eclipse.gef.examples.text.model.Style;

public abstract class Container
extends ModelElement {
    public static final int TYPE_BULLETED_LIST = 1;
    public static final int TYPE_COMMENT = 2;
    public static final int TYPE_IMPORT_DECLARATIONS = 3;
    public static final int TYPE_PARAGRAPH = 4;
    public static final int TYPE_ROOT = 5;
    public static final int TYPE_INLINE = 6;
    public static final int TYPE_CODE = 7;
    private static final long serialVersionUID = 1L;
    private List children = new ArrayList();
    private Style style = new Style();

    public Container(int type) {
        this.type = type;
    }

    public void add(ModelElement child) {
        this.add(child, -1);
    }

    public void add(ModelElement child, int index) {
        child.setParent(this);
        if (index == -1) {
            index = this.children.size();
        }
        this.children.add(index, child);
        this.firePropertyChange("children", null, child);
    }

    public boolean contains(ModelElement child) {
        do {
            if (child.getContainer() != this) continue;
            return true;
        } while ((child = child.getContainer()) != null);
        return false;
    }

    public List getChildren() {
        return this.children;
    }

    public int getChildType() {
        switch (this.getType()) {
            case 3: {
                return 1;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    public Style getStyle() {
        return this.style;
    }

    public int remove(ModelElement child) {
        int index = this.children.indexOf(child);
        this.children.remove(child);
        child.setParent(null);
        this.firePropertyChange("children", child, null);
        return index;
    }

    public void removeAll(Collection children) {
        if (children.removeAll(children)) {
            this.firePropertyChange("children", children, null);
        }
    }

    @Override
    public void setParent(Container container) {
        super.setParent(container);
        if (container == null) {
            this.getStyle().setParentStyle(null);
        } else {
            this.getStyle().setParentStyle(container.getStyle());
        }
    }

    @Override
    public int size() {
        return this.getChildren().size();
    }

    abstract Container newContainer();

    public Container subdivideContainer(int offset) {
        Container result = this.newContainer();
        List reparent = this.getChildren().subList(offset, this.getChildren().size());
        this.removeAll(reparent);
        result.getChildren().addAll(reparent);
        return result;
    }
}

