/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.canvas;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.cdt.visualizer.ui.canvas.IGraphicObject;
import org.eclipse.cdt.visualizer.ui.canvas.ITooltipProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class GraphicObject
implements IGraphicObject,
ITooltipProvider {
    protected Object m_data = null;
    protected Rectangle m_bounds = new Rectangle(0, 0, 0, 0);
    protected boolean m_visible = true;
    protected boolean m_selected = false;
    protected Color m_foreground = null;
    protected Color m_background = null;

    public GraphicObject() {
    }

    public GraphicObject(int x, int y, int width, int height) {
        this.m_bounds.x = x;
        this.m_bounds.y = y;
        this.m_bounds.width = width;
        this.m_bounds.height = height;
    }

    public GraphicObject(Rectangle bounds) {
        this.m_bounds.x = bounds.x;
        this.m_bounds.y = bounds.y;
        this.m_bounds.width = bounds.width;
        this.m_bounds.height = bounds.height;
    }

    public GraphicObject(Object data) {
        this.m_data = data;
    }

    public GraphicObject(int x, int y, int width, int height, Object data) {
        this.m_bounds.x = x;
        this.m_bounds.y = y;
        this.m_bounds.width = width;
        this.m_bounds.height = height;
        this.m_data = data;
    }

    public GraphicObject(Rectangle bounds, Object data) {
        this.m_bounds.x = bounds.x;
        this.m_bounds.y = bounds.y;
        this.m_bounds.width = bounds.width;
        this.m_bounds.height = bounds.height;
        this.m_data = data;
    }

    public void dispose() {
        this.m_data = null;
    }

    @Override
    public Object getData() {
        return this.m_data;
    }

    @Override
    public void setData(Object data) {
        this.m_data = data;
    }

    public int getX() {
        return this.m_bounds.x;
    }

    public void setX(int x) {
        this.m_bounds.x = x;
    }

    public int getY() {
        return this.m_bounds.y;
    }

    public void setY(int y) {
        this.m_bounds.y = y;
    }

    public void setPosition(int x, int y) {
        this.m_bounds.x = x;
        this.m_bounds.y = y;
    }

    public int getWidth() {
        return this.m_bounds.width;
    }

    public void setWidth(int w) {
        this.m_bounds.width = w;
    }

    public int getHeight() {
        return this.m_bounds.height;
    }

    public void setHeight(int h) {
        this.m_bounds.height = h;
    }

    public void setSize(int w, int h) {
        this.m_bounds.width = w;
        this.m_bounds.height = h;
    }

    public Rectangle getBounds() {
        return this.m_bounds;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.m_bounds.x = x;
        this.m_bounds.y = y;
        this.m_bounds.width = w;
        this.m_bounds.height = h;
    }

    public void setBounds(Rectangle bounds) {
        this.m_bounds.x = bounds.x;
        this.m_bounds.y = bounds.y;
        this.m_bounds.width = bounds.width;
        this.m_bounds.height = bounds.height;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.m_bounds.contains(x, y);
    }

    @Override
    public boolean isWithin(Rectangle region) {
        return region.x <= this.m_bounds.x && region.y <= this.m_bounds.y && region.x + region.width >= this.m_bounds.x + this.m_bounds.width && region.y + region.height >= this.m_bounds.y + this.m_bounds.height;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }

    public void setForeground(Color color) {
        this.m_foreground = color;
    }

    public Color getForeground() {
        return this.m_foreground;
    }

    public void setBackground(Color color) {
        this.m_background = color;
    }

    public Color getBackground() {
        return this.m_background;
    }

    @Override
    public void paint(GC gc, boolean decorations) {
        if (this.isVisible()) {
            Color oldForeground = null;
            Color oldBackground = null;
            if (this.m_foreground != null) {
                oldForeground = gc.getForeground();
                gc.setForeground(this.m_foreground);
            }
            if (this.m_background != null) {
                oldBackground = gc.getBackground();
                gc.setBackground(this.m_background);
            }
            if (!decorations) {
                this.paintContent(gc);
            } else {
                this.paintDecorations(gc);
            }
            if (this.m_foreground != null) {
                gc.setForeground(oldForeground);
            }
            if (this.m_background != null) {
                gc.setBackground(oldBackground);
            }
        }
    }

    public void paintContent(GC gc) {
        gc.drawRectangle(this.m_bounds);
        if (this.isSelected()) {
            int height;
            int x = this.m_bounds.x + 1;
            int y = this.m_bounds.y + 1;
            int width = this.m_bounds.width - 2;
            if (width < 0) {
                width = 0;
            }
            if ((height = this.m_bounds.height - 2) < 0) {
                height = 0;
            }
            gc.drawRectangle(x, y, width, height);
        }
    }

    @Override
    public boolean hasDecorations() {
        return false;
    }

    public void paintDecorations(GC gc) {
    }

    @Override
    public String getTooltip(int x, int y) {
        return null;
    }

    public void drawImage(GC gc, String imgPath, Rectangle imgRelPositionAndScale) throws FileNotFoundException {
        this.drawImageWithMargin(gc, imgPath, imgRelPositionAndScale, 0);
    }

    public void drawImage(GC gc, String imgPath, ImageSizeAndPosition sizeAndpos) throws FileNotFoundException {
        this.drawImageWithMargin(gc, imgPath, sizeAndpos.getValue(), 0);
    }

    public void drawImageWithMargin(GC gc, String imgPath, ImageSizeAndPosition sizeAndpos, int margin) throws FileNotFoundException {
        this.drawImageWithMargin(gc, imgPath, sizeAndpos.getValue(), margin);
    }

    public void drawImageWithMargin(GC gc, String imgPath, Rectangle imgRelPositionAndScale, int margin) throws FileNotFoundException {
        File file = new File(imgPath);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (margin < 0) {
            margin = 0;
        }
        int imgPosX = imgRelPositionAndScale.x;
        int imgPosY = imgRelPositionAndScale.y;
        int imgScaleW = imgRelPositionAndScale.width;
        int imgScaleH = imgRelPositionAndScale.height;
        float posX = (float)this.m_bounds.x + (float)this.m_bounds.width * (float)imgPosX / 100.0f + (float)margin;
        float posY = (float)this.m_bounds.y + (float)this.m_bounds.height * (float)imgPosY / 100.0f + (float)margin;
        float width = (float)this.m_bounds.width * (float)imgScaleW / 100.0f - (float)(2 * margin);
        float height = (float)this.m_bounds.height * (float)imgScaleH / 100.0f - (float)(2 * margin);
        Image img = new Image(gc.getDevice(), imgPath);
        gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, Math.round(posX), Math.round(posY), Math.round(width), Math.round(height));
    }

    public static enum ImageSizeAndPosition {
        UPPER_LEFT_QUADRANT(new Rectangle(0, 0, 50, 50)),
        UPPER_RIGHT_QUADRANT(new Rectangle(50, 0, 50, 50)),
        LOWER_LEFT_QUADRANT(new Rectangle(0, 50, 50, 50)),
        LOWER_RIGHT_QUADRANT(new Rectangle(50, 50, 50, 50)),
        LOWER_RIGHT_HEIGHTH(new Rectangle(75, 75, 25, 25)),
        UPPER_LEFT_SEVENTH_HEIGHTH(new Rectangle(0, 0, 75, 75)),
        MAXSIZE(new Rectangle(0, 0, 100, 100));

        private Rectangle value;

        private ImageSizeAndPosition(Rectangle sizeAndPos) {
            this.value = sizeAndPos;
        }

        public Rectangle getValue() {
            return this.value;
        }
    }
}

