/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractAnnotationHover;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionProcessor;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.cdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IProblemLocation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemHover
extends AbstractAnnotationHover {
    public ProblemHover() {
        super(false);
    }

    @Override
    protected AbstractAnnotationHover.AnnotationInfo createAnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
        return new ProblemInfo(annotation, position, textViewer);
    }

    protected static class ProblemInfo
    extends AbstractAnnotationHover.AnnotationInfo {
        private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];

        public ProblemInfo(Annotation annotation, Position position, ITextViewer textViewer) {
            super(annotation, position, textViewer);
        }

        @Override
        public ICompletionProposal[] getCompletionProposals() {
            if (this.annotation instanceof ICAnnotation) {
                return this.getCAnnotationFixes((ICAnnotation)this.annotation);
            }
            if (this.annotation instanceof MarkerAnnotation) {
                return this.getMarkerAnnotationFixes((MarkerAnnotation)this.annotation);
            }
            return NO_PROPOSALS;
        }

        private ICompletionProposal[] getCAnnotationFixes(ICAnnotation cAnnotation) {
            ProblemLocation location = new ProblemLocation(this.position.getOffset(), this.position.getLength(), cAnnotation);
            ITranslationUnit tu = cAnnotation.getTranslationUnit();
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            CorrectionContext context = new CorrectionContext(tu, sourceViewer, location.getOffset(), location.getLength());
            if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(cAnnotation.getType())) {
                return NO_PROPOSALS;
            }
            ArrayList<ICCompletionProposal> proposals = new ArrayList<ICCompletionProposal>();
            CCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
            Collections.sort(proposals, new CCompletionProposalComparator());
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private ICompletionProposal[] getMarkerAnnotationFixes(MarkerAnnotation markerAnnotation) {
            if (markerAnnotation.isQuickFixableStateSet() && !markerAnnotation.isQuickFixable()) {
                return NO_PROPOSALS;
            }
            IMarker marker = markerAnnotation.getMarker();
            IEditorInput input = null;
            try {
                input = EditorUtility.getEditorInput(marker.getResource());
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
            if (input == null) {
                return NO_PROPOSALS;
            }
            ITranslationUnit tu = ProblemInfo.getTranslationUnit(input);
            if (tu == null) {
                return NO_PROPOSALS;
            }
            IAnnotationModel model = CUIPlugin.getDefault().getDocumentProvider().getAnnotationModel(input);
            if (model == null) {
                return NO_PROPOSALS;
            }
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            CorrectionContext context = new CorrectionContext(tu, sourceViewer, this.position.getOffset(), this.position.getLength());
            ArrayList<ICCompletionProposal> proposals = new ArrayList<ICCompletionProposal>();
            CCorrectionProcessor.collectProposals(context, model, new Annotation[]{markerAnnotation}, true, false, proposals);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private static ITranslationUnit getTranslationUnit(IEditorInput input) {
            return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
        }
    }
}

