/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.marte.gqam.GqamPackage;
import org.polarsys.time4sys.marte.gqam.InputPin;
import org.polarsys.time4sys.marte.gqam.OutputPin;
import org.polarsys.time4sys.marte.gqam.PeriodicPattern;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.gqam.WorkloadEvent;
import org.polarsys.time4sys.marte.grm.EDFParameters;
import org.polarsys.time4sys.marte.grm.SchedulableResource;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Transformation;
import org.polarsys.time4sys.transformations.AbstractTransformation;
import org.polarsys.time4sys.transformations.IdentityDerivation;

public class ActivationPropagator
extends AbstractTransformation {
    public static final String TRANS_NAME = ActivationPropagator.class.getSimpleName();
    public static final String CTRL2DATAFLOW_RULE = "control2data-flow rule";
    public static final String DEP_SRC_ROLE = "dependency source";
    public static final String DEP_TGT_ROLE = "dependency target";
    public static final String DEP2ACTIVATION_RULE = "dependency activation propagation rule";
    protected Queue<Link> controlFlowOutputPinWithCauseLnks = new LinkedList<Link>();
    private Context control2dataFlow;
    private Context dep2activationRule;
    private final ActivationPropagatorConfiguration config;

    public static Transformation transform(Project project, DesignModel source) {
        return ActivationPropagator.transform(ActivationPropagator.defaultCfg(), project, source);
    }

    public static Transformation transform(ActivationPropagatorConfiguration cfg, Project project, DesignModel source) {
        return new ActivationPropagator(cfg, project, source).transform();
    }

    public static ActivationPropagatorConfiguration defaultCfg() {
        return new ActivationPropagatorConfiguration();
    }

    public ActivationPropagator(ActivationPropagatorConfiguration cfg, Project project, DesignModel source) {
        super(project, source, TRANS_NAME);
        this.config = cfg;
    }

    @Override
    public void createRules() {
        super.createRules();
        this.control2dataFlow = mappingFactory.createContext(CTRL2DATAFLOW_RULE);
        this.mapping.getRules().add((Object)this.control2dataFlow);
        this.dep2activationRule = mappingFactory.createContext(DEP2ACTIVATION_RULE);
        this.mapping.getRules().add((Object)this.dep2activationRule);
    }

    @Override
    public void copied(EObject source, Link lnk, EObject theCopy) {
        Step sourceStep;
        if (source instanceof OutputPin && ((OutputPin)source).isIsControl() && (sourceStep = (Step)source.eContainer()).getCause() != null && !sourceStep.getCause().isEmpty()) {
            this.controlFlowOutputPinWithCauseLnks.add(lnk);
        }
    }

    @Override
    protected void finalize(DesignModel target) {
        while (!this.controlFlowOutputPinWithCauseLnks.isEmpty()) {
            Link lnk = this.controlFlowOutputPinWithCauseLnks.poll();
            OutputPin originalOutputPin = (OutputPin)lnk.getUniqueSourceValue(IdentityDerivation.ORIGINAL_ROLE);
            OutputPin copyOutputPin = (OutputPin)lnk.getUniqueTargetValue(IdentityDerivation.COPY_ROLE);
            Step copyStepWithCause = (Step)copyOutputPin.eContainer();
            lnk.setRationale(this.control2dataFlow);
            for (InputPin copyInputPin : copyOutputPin.getSuccessors()) {
                if (this.config.forAllStep || this.isCrossTasks(copyOutputPin, copyInputPin)) {
                    copyInputPin.setIsControl(false);
                    copyOutputPin.setIsControl(false);
                }
                for (Link lnkInput : this.mapping.getLinksForSlice((EObject)copyInputPin)) {
                    lnkInput.setRationale(this.control2dataFlow);
                    InputPin originalInputPin = (InputPin)lnkInput.getUniqueSourceValue(COPY_ROLE);
                    Step copyNextStep = (Step)copyInputPin.eContainer();
                    this.propagate(target, originalOutputPin, originalInputPin, copyStepWithCause, copyNextStep, lnk);
                    for (OutputPin outputPinWithNewlyCause : copyNextStep.getOutputPin()) {
                        this.controlFlowOutputPinWithCauseLnks.addAll((Collection<Link>)this.mapping.getLinksForSlice((EObject)outputPinWithNewlyCause));
                    }
                }
            }
        }
        DesignBuilder targetDesignBuilder = new DesignBuilder(target);
        Collection<Step> allSteps = targetDesignBuilder.allSteps();
        boolean needsUpate = true;
        while (needsUpate) {
            needsUpate = false;
            for (Step aStep : allSteps) {
                for (InputPin ipin : aStep.getInputPin()) {
                    for (OutputPin opin : ipin.getPredecessors()) {
                        boolean bl = needsUpate = needsUpate || this.checkOrUpdate(targetDesignBuilder, (Step)ipin.eContainer(), (Step)opin.eContainer());
                    }
                }
            }
        }
        if (!this.config.forAllStep) {
            this.removeUnnecessaryActivations(target);
        }
    }

    private void removeUnnecessaryActivations(DesignModel target) {
        for (Step aStep : new DesignBuilder(target).allSteps()) {
            if (!this.hasControlFlowInput(aStep)) continue;
            aStep.getCause().clear();
        }
    }

    private boolean hasControlFlowInput(Step aStep) {
        return aStep.getInputPin().stream().anyMatch(new Predicate<InputPin>(){

            @Override
            public boolean test(InputPin t) {
                return t.isIsControl();
            }
        });
    }

    protected void removeUnnecessaryActivations() {
    }

    protected boolean isCrossTasks(OutputPin copyOutputPin, InputPin copyInputPin) {
        return ((Step)copyOutputPin.eContainer()).getConcurRes() != ((Step)copyInputPin.eContainer()).getConcurRes();
    }

    protected boolean checkOrUpdate(DesignBuilder resultingDesign, Step target, Step source) {
        StepBuilder step_i = new StepBuilder(resultingDesign, source);
        StepBuilder step_j = new StepBuilder(resultingDesign, target);
        Duration d_i = step_i.getDeadline();
        Duration d_j = step_j.getDeadline();
        if (d_i == null || d_j == null) {
            return false;
        }
        if (d_i.compareTo(d_j) > 0) {
            step_i.getTask().setDeadline(d_j);
            return true;
        }
        return false;
    }

    protected void propagate(DesignModel copyDesign, OutputPin originalOutputPin, InputPin originalInputPin, Step copyStepWithCause, Step copyNextStep, Link outputPinsLink) {
        assert (copyStepWithCause != null);
        EDFParameters edfSchedParam = this.propagateDeadline(copyDesign, originalOutputPin, originalInputPin, copyStepWithCause.getConcurRes(), copyNextStep.getConcurRes(), outputPinsLink);
        Duration delta = this.propagateWorkloadEvt(copyDesign, originalOutputPin, originalInputPin, copyStepWithCause, copyNextStep, outputPinsLink);
        if (delta != null && edfSchedParam != null) {
            edfSchedParam.setDeadline(edfSchedParam.getDeadline().sub(delta));
        }
    }

    protected EDFParameters propagateDeadline(DesignModel copyDesign, OutputPin originalOutputPin, InputPin originalInputPin, SchedulableResource copyTaskWithCause, SchedulableResource copyNextTask, Link outputPinsLink) {
        assert (copyTaskWithCause != null);
        new TaskBuilder(null, (SoftwareSchedulableResource)copyTaskWithCause).getEDFSchedParams(false);
        EDFParameters nextSchedParam = new TaskBuilder(null, (SoftwareSchedulableResource)copyNextTask).getEDFSchedParams(false);
        if (nextSchedParam == null) {
            nextSchedParam = this.copyDeadline(copyDesign, originalOutputPin, originalInputPin, copyTaskWithCause, copyNextTask, outputPinsLink);
        }
        return nextSchedParam;
    }

    protected EDFParameters copyDeadline(DesignModel copyDesign, OutputPin originalOutputPin, InputPin originalInputPin, SchedulableResource copyTaskWithCause, SchedulableResource copyNextTask, Link outputPinsLink) {
        EDFParameters toCopySchedParam = new TaskBuilder(null, (SoftwareSchedulableResource)copyTaskWithCause).getEDFSchedParams(false);
        if (toCopySchedParam == null) {
            return null;
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EDFParameters newSchedParams = (EDFParameters)copier.copy((EObject)toCopySchedParam);
        copyNextTask.getSchedParams().add((Object)newSchedParams);
        copier.copyReferences();
        return newSchedParams;
    }

    protected Duration propagateWorkloadEvt(DesignModel copyDesign, OutputPin originalOutputPin, InputPin originalInputPin, Step copyStepWithCause, Step copyNextStep, Link outputPinsLink) {
        Duration result = null;
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        for (WorkloadEvent evt : copyStepWithCause.getCause()) {
            Duration deadlineChange;
            WorkloadEvent similarEvt = this.findSimilar(copyNextStep, evt);
            result = similarEvt == null ? (deadlineChange = this.copyWorkloadEvent(copyDesign, originalOutputPin, originalInputPin, copyNextStep, outputPinsLink, copier, evt)) : (deadlineChange = this.mergeWorkloadEvent(similarEvt, originalOutputPin, originalInputPin, copyNextStep, outputPinsLink, copier, evt));
        }
        copier.copyReferences();
        return result;
    }

    protected WorkloadEvent findSimilar(Step copyNextStep, WorkloadEvent evt) {
        for (WorkloadEvent existingEvt : copyNextStep.getCause()) {
            if (!evt.getPattern().getClass().isInstance(existingEvt.getPattern())) continue;
            return existingEvt;
        }
        return null;
    }

    protected Duration mergeWorkloadEvent(WorkloadEvent similarEvt, OutputPin originalOutputPin, InputPin originalInputPin, Step copyNextStep, Link outputPinsLink, EcoreUtil.Copier copier, WorkloadEvent evt) {
        if (similarEvt.getPattern() instanceof PeriodicPattern) {
            PeriodicPattern mergedPattern = (PeriodicPattern)similarEvt.getPattern();
            PeriodicPattern mergeePattern = (PeriodicPattern)evt.getPattern();
            return this.mergePeriodicPattern(mergeePattern, mergedPattern);
        }
        throw new IllegalArgumentException("Propagation of " + similarEvt.getPattern().getClass().getSimpleName() + " kind of activation is unknown.");
    }

    private Duration mergePeriodicPattern(PeriodicPattern mergeePattern, PeriodicPattern mergedPattern) {
        return this.mergeOffset(mergeePattern, mergedPattern);
    }

    private Duration mergeOffset(PeriodicPattern mergeePattern, PeriodicPattern mergedPattern) {
        if (mergeePattern.eIsSet((EStructuralFeature)GqamPackage.eINSTANCE.getArrivalPattern_Phase())) {
            if (mergedPattern.eIsSet((EStructuralFeature)GqamPackage.eINSTANCE.getArrivalPattern_Phase())) {
                Duration oldValue = mergedPattern.getPhase();
                mergedPattern.setPhase(mergedPattern.getPhase().max(mergeePattern.getPhase()));
                return mergedPattern.getPhase().sub(oldValue);
            }
            mergedPattern.setPhase(mergeePattern.getPhase());
            return mergedPattern.getPhase();
        }
        return null;
    }

    protected Duration copyWorkloadEvent(DesignModel copyDesign, OutputPin originalOutputPin, InputPin originalInputPin, Step copyNextStep, Link outputPinsLink, EcoreUtil.Copier copier, WorkloadEvent evt) {
        WorkloadEvent newCause = (WorkloadEvent)copier.copy((EObject)evt);
        newCause.setName(String.valueOf(newCause.getName()) + "_x_" + copyNextStep.getName());
        copyDesign.getWorkloadBehavior().getDemand().add((Object)newCause);
        copyNextStep.getCause().add((Object)newCause);
        Link lnk = mappingFactory.createLink();
        lnk.getTargets().add((Object)mappingFactory.createMappableArtefact(COPY_ROLE, (EObject)newCause));
        lnk.getSources().add((Object)mappingFactory.createMappableArtefact(DEP_SRC_ROLE, (EObject)originalInputPin));
        lnk.getSources().add((Object)mappingFactory.createMappableArtefact(DEP_TGT_ROLE, (EObject)originalOutputPin));
        lnk.setRationale(this.dep2activationRule);
        outputPinsLink.getSubLinks().add((Object)lnk);
        if (newCause.getPattern() instanceof PeriodicPattern) {
            return ((PeriodicPattern)newCause.getPattern()).getPhase();
        }
        return null;
    }

    public static class ActivationPropagatorConfiguration {
        protected boolean forAllStep;

        public ActivationPropagatorConfiguration() {
            this.forAllStep = false;
        }

        public ActivationPropagatorConfiguration(ActivationPropagatorConfiguration original) {
            this.forAllStep = original.forAllStep;
        }

        public ActivationPropagatorConfiguration withPropagationOnEveryStep() {
            ActivationPropagatorConfiguration result = new ActivationPropagatorConfiguration(this);
            result.forAllStep = true;
            return result;
        }
    }
}

