/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.handler;

import com.microsoft.java.test.plugin.provider.TestKindProvider;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ClasspathUpdateHandler
implements IElementChangedListener {
    public void elementChanged(ElementChangedEvent event) {
        Set<IJavaProject> projects = this.processDelta(event.getDelta(), null);
        if (projects != null && projects != null) {
            for (IJavaProject project : projects) {
                TestKindProvider.updateTestKinds(project);
            }
        }
    }

    public void addElementChangeListener() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void removeElementChangeListener() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    private Set<IJavaProject> processDeltaChildren(IJavaElementDelta delta, Set<IJavaProject> projects) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta c = iJavaElementDeltaArray[n2];
            projects = this.processDelta(c, projects);
            ++n2;
        }
        return projects;
    }

    private Set<IJavaProject> processDelta(IJavaElementDelta delta, Set<IJavaProject> projects) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                projects = this.processDeltaChildren(delta, projects);
                break;
            }
            case 2: {
                if (!this.isClasspathChanged(delta.getFlags())) break;
                if (projects == null) {
                    projects = new HashSet<IJavaProject>();
                }
                projects.add((IJavaProject)element);
                break;
            }
        }
        return projects;
    }

    private boolean isClasspathChanged(int flags) {
        return (flags & 0x220600) != 0;
    }
}

