/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.TypeMismatchBaseSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MissingReturnTypeCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MissingReturnTypeInLambdaCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ReplaceCorrectionProposalCore;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;

public abstract class ReturnTypeBaseSubProcessor<T> {
    protected static final int MethodWithConstructorName1 = 100;
    protected static final int VoidMethodReturns1 = 210;
    protected static final int VoidMethodReturns2 = 220;
    protected static final int MissingReturnTypeProposal1 = 310;
    protected static final int MissingReturnTypeProposal2 = 320;
    protected static final int MissingReturnStatementProposal1 = 410;
    protected static final int MissingReturnStatementProposal2 = 420;
    protected static final int MissingReturnStatementProposal3 = 430;
    protected static final int ReplaceReturnWithYieldStatementProposal1 = 510;

    protected ReturnTypeBaseSubProcessor() {
    }

    public void collectMethodWithConstrNameProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)selectedNode;
            ASTRewrite rewrite = ASTRewrite.create((AST)declaration.getAST());
            rewrite.set((ASTNode)declaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
            String label = CorrectionMessages.ReturnTypeSubProcessor_constrnamemethod_description;
            ASTRewriteCorrectionProposalCore p = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 5);
            T proposal = this.rewriteCorrectionProposalToT(p, 100);
            if (proposal != null) {
                proposals.add(proposal);
            }
        }
    }

    public void collectVoidMethodReturnsProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            if (selectedNode.getNodeType() == 41) {
                ReturnStatement returnStatement = (ReturnStatement)selectedNode;
                Expression expr = returnStatement.getExpression();
                if (expr != null) {
                    T wrapped;
                    AST ast = astRoot.getAST();
                    ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                    if (binding == null) {
                        binding = ast.resolveWellKnownType("java.lang.Object");
                    }
                    if (binding.isWildcardType()) {
                        binding = ASTResolving.normalizeWildcardType(binding, true, ast);
                    }
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_voidmethodreturns_description, BindingLabelProviderCore.getBindingLabel((IBinding)binding, 0x200009L));
                    LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label, cu, rewrite, 6);
                    ImportRewrite imports = proposal.createImportRewrite(astRoot);
                    ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)methodDeclaration, imports);
                    Type newReturnType = imports.addImport(binding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
                    if (methodDeclaration.isConstructor()) {
                        rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
                        rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
                    } else {
                        rewrite.replace((ASTNode)methodDeclaration.getReturnType2(), (ASTNode)newReturnType, null);
                    }
                    String key = "return_type";
                    proposal.addLinkedPosition(rewrite.track((ASTNode)newReturnType), true, key);
                    ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(ast, binding);
                    int n = iTypeBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding b = iTypeBindingArray[n2];
                        proposal.addLinkedPositionProposal(key, b);
                        ++n2;
                    }
                    Javadoc javadoc = methodDeclaration.getJavadoc();
                    if (javadoc != null) {
                        TagElement newTag = ast.newTagElement();
                        newTag.setTagName("@return");
                        TextElement commentStart = ast.newTextElement();
                        newTag.fragments().add(commentStart);
                        JavadocTagsSubProcessorCore.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
                        proposal.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
                    }
                    if ((wrapped = this.linkedCorrectionProposal1ToT(proposal, 210)) != null) {
                        proposals.add(wrapped);
                    }
                }
                ASTRewrite rewrite = ASTRewrite.create((AST)decl.getAST());
                rewrite.remove((ASTNode)returnStatement.getExpression(), null);
                String label = CorrectionMessages.ReturnTypeSubProcessor_removereturn_description;
                ASTRewriteCorrectionProposalCore core = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 5);
                T proposal = this.rewriteCorrectionProposalToT(core, 220);
                if (proposal != null) {
                    proposals.add(proposal);
                }
            }
        }
    }

    public void collectMissingReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            ASTNode parentType;
            T wrapped;
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            ReturnStatementCollector eval = new ReturnStatementCollector();
            decl.accept((ASTVisitor)eval);
            AST ast = astRoot.getAST();
            ITypeBinding typeBinding = eval.getTypeBinding(decl.getAST());
            typeBinding = Bindings.normalizeTypeBinding(typeBinding);
            if (typeBinding == null) {
                typeBinding = ast.resolveWellKnownType("void");
            }
            if (typeBinding.isWildcardType()) {
                typeBinding = ASTResolving.normalizeWildcardType(typeBinding, true, ast);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_missingreturntype_description, BindingLabelProviderCore.getBindingLabel((IBinding)typeBinding, 0x200009L));
            LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label, cu, rewrite, 6);
            ImportRewrite imports = proposal.createImportRewrite(astRoot);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)decl, imports);
            Type type = imports.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
            rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
            rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
            Javadoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null && typeBinding != null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@return");
                TextElement commentStart = ast.newTextElement();
                newTag.fragments().add(commentStart);
                JavadocTagsSubProcessorCore.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
                proposal.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
            }
            String key = "return_type";
            proposal.addLinkedPosition(rewrite.track((ASTNode)type), true, key);
            if (typeBinding != null) {
                ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(ast, typeBinding);
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding binding = iTypeBindingArray[n2];
                    proposal.addLinkedPositionProposal(key, binding);
                    ++n2;
                }
            }
            if ((wrapped = this.linkedCorrectionProposal1ToT(proposal, 310)) != null) {
                proposals.add(wrapped);
            }
            if ((parentType = ASTResolving.findParentType((ASTNode)decl)) instanceof AbstractTypeDeclaration) {
                boolean isInterface;
                AbstractTypeDeclaration parentTypeDecl = (AbstractTypeDeclaration)parentType;
                boolean bl = isInterface = parentType instanceof TypeDeclaration && ((TypeDeclaration)parentType).isInterface();
                if (!isInterface) {
                    String constructorName = parentTypeDecl.getName().getIdentifier();
                    SimpleName nameNode = methodDeclaration.getName();
                    label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_wrongconstructorname_description, BasicElementLabels.getJavaElementName(constructorName));
                    ReplaceCorrectionProposalCore core = new ReplaceCorrectionProposalCore(label, cu, nameNode.getStartPosition(), nameNode.getLength(), constructorName, 5);
                    T prop = this.replaceCorrectionProposalToT(core, 320);
                    if (prop != null) {
                        proposals.add(prop);
                    }
                }
            }
        }
    }

    public void collectMissingReturnStatementProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ReturnStatement existingStatement;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        ReturnStatement returnStatement = existingStatement = selectedNode instanceof ReturnStatement ? (ReturnStatement)selectedNode : null;
        if (selectedNode instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)selectedNode;
            MissingReturnTypeInLambdaCorrectionProposalCore core = new MissingReturnTypeInLambdaCorrectionProposalCore(cu, lambda, existingStatement, 6);
            T prop = this.missingReturnTypeInLambdaProposalToT(core, 410);
            if (prop != null) {
                proposals.add(prop);
            }
        } else {
            BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
            if (decl instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)decl;
                Block block = methodDecl.getBody();
                if (block == null) {
                    return;
                }
                MissingReturnTypeCorrectionProposalCore core = new MissingReturnTypeCorrectionProposalCore(cu, methodDecl, existingStatement, 6);
                T p = this.missingReturnTypeProposalToT(core, 420);
                proposals.add(p);
                Type returnType = methodDecl.getReturnType2();
                if (returnType != null && !"void".equals(ASTNodes.asString((ASTNode)returnType))) {
                    String label;
                    ASTRewriteCorrectionProposalCore core2;
                    T proposal;
                    TagElement tagElement;
                    AST ast = methodDecl.getAST();
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    rewrite.replace((ASTNode)returnType, (ASTNode)ast.newPrimitiveType(PrimitiveType.VOID), null);
                    Javadoc javadoc = methodDecl.getJavadoc();
                    if (javadoc != null && (tagElement = JavadocTagsSubProcessorCore.findTag(javadoc, "@return", null)) != null) {
                        rewrite.remove((ASTNode)tagElement, null);
                    }
                    if ((proposal = this.rewriteCorrectionProposalToT(core2 = new ASTRewriteCorrectionProposalCore(label = CorrectionMessages.ReturnTypeSubProcessor_changetovoid_description, cu, rewrite, 5), 430)) != null) {
                        proposals.add(proposal);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void collectReplaceReturnWithYieldStatementProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        void returnStatement;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof ReturnStatement)) {
            return;
        }
        ReturnStatement returnStatement2 = (ReturnStatement)selectedNode;
        Expression expression = returnStatement.getExpression();
        if (expression == null) {
            return;
        }
        ASTNode parent = returnStatement.getParent();
        List stmts = null;
        if (parent instanceof Block) {
            Block block = (Block)parent;
            stmts = block.statements();
        } else if (parent instanceof SwitchExpression) {
            SwitchExpression switchExp = (SwitchExpression)parent;
            stmts = switchExp.statements();
        }
        if (stmts != null) {
            int index = stmts.indexOf(returnStatement);
            if (index < 0) {
                return;
            }
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            YieldStatement yieldStatement = ast.newYieldStatement();
            yieldStatement.setExpression((Expression)rewrite.createMoveTarget((ASTNode)expression));
            rewrite.replace((ASTNode)returnStatement, (ASTNode)yieldStatement, null);
            String label = CorrectionMessages.ReturnTypeSubProcessor_changeReturnToYield_description;
            ASTRewriteCorrectionProposalCore core = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 6);
            T proposal = this.rewriteCorrectionProposalToT(core, 510);
            if (proposal != null) {
                proposals.add(proposal);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void collectMethodReturnsVoidProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws JavaModelException {
        void returnStatement;
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof ReturnStatement)) {
            return;
        }
        ReturnStatement returnStatement2 = (ReturnStatement)selectedNode;
        Expression expression = returnStatement.getExpression();
        if (expression == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methDecl = (MethodDeclaration)decl;
            Type retType = methDecl.getReturnType2();
            if (retType == null || retType.resolveBinding() == null) {
                return;
            }
            TypeMismatchBaseSubProcessor<T> sub = this.getTypeMismatchSubProcessor();
            if (sub != null) {
                sub.collectChangeSenderTypeProposals(context, expression, retType.resolveBinding(), false, 4, proposals);
            }
        }
    }

    protected abstract TypeMismatchBaseSubProcessor<T> getTypeMismatchSubProcessor();

    protected abstract T linkedCorrectionProposal1ToT(LinkedCorrectionProposalCore var1, int var2);

    protected abstract T rewriteCorrectionProposalToT(ASTRewriteCorrectionProposalCore var1, int var2);

    protected abstract T replaceCorrectionProposalToT(ReplaceCorrectionProposalCore var1, int var2);

    protected abstract T missingReturnTypeProposalToT(MissingReturnTypeCorrectionProposalCore var1, int var2);

    protected abstract T missingReturnTypeInLambdaProposalToT(MissingReturnTypeInLambdaCorrectionProposalCore var1, int var2);

    private static class ReturnStatementCollector
    extends ASTVisitor {
        private ArrayList<ReturnStatement> fResult = new ArrayList();

        private ReturnStatementCollector() {
        }

        public ITypeBinding getTypeBinding(AST ast) {
            boolean couldBeObject = false;
            for (ReturnStatement node : this.fResult) {
                Expression expr = node.getExpression();
                if (expr != null) {
                    ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                    if (binding != null) {
                        return binding;
                    }
                    couldBeObject = true;
                    continue;
                }
                return ast.resolveWellKnownType("void");
            }
            if (couldBeObject) {
                return ast.resolveWellKnownType("java.lang.Object");
            }
            return ast.resolveWellKnownType("void");
        }

        public boolean visit(ReturnStatement node) {
            this.fResult.add(node);
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }

        public boolean visit(EnumDeclaration node) {
            return false;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return false;
        }
    }
}

