/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.HtmlConverterOptions;
import com.vladsch.flexmark.html2md.converter.HtmlMarkdownWriter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import java.io.Reader;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.AbstractJavaDocConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.TableHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class JavaDoc2MarkdownConverter
extends AbstractJavaDocConverter {
    private static final String MARKDOWN_SPACE = "&nbsp;";
    private static final String LINEBREAK = "\n";
    private static final String DOUBLE_SPACE = "  ";
    private final FlexmarkHtmlConverter converter;
    private final DataHolder flexmarkOptions = JavaDoc2MarkdownConverter.initOptions();
    private final HtmlConverterOptions myHtmlConverterOptions = new HtmlConverterOptions(this.flexmarkOptions);

    public JavaDoc2MarkdownConverter(Reader reader) {
        super(reader);
        this.converter = this.initConverter(this.flexmarkOptions);
    }

    public JavaDoc2MarkdownConverter(String javadoc) {
        super(javadoc);
        this.converter = this.initConverter(this.flexmarkOptions);
    }

    private static DataHolder initOptions() {
        MutableDataSet flexmarkOptions = new MutableDataSet();
        String[] unwrappedTags = (String[])FlexmarkHtmlConverter.UNWRAPPED_TAGS.getDefaultValue();
        String[] extendedUnwrappedTags = Arrays.copyOf(unwrappedTags, unwrappedTags.length + 1);
        extendedUnwrappedTags[unwrappedTags.length] = "abbr";
        flexmarkOptions.set(FlexmarkHtmlConverter.UNWRAPPED_TAGS, (Object)extendedUnwrappedTags);
        flexmarkOptions.set(FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_ID, (Object)false);
        flexmarkOptions.set(FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS, (Object)false);
        return flexmarkOptions;
    }

    private FlexmarkHtmlConverter initConverter(DataHolder flexmarkOptions) {
        FlexmarkHtmlConverter converter = FlexmarkHtmlConverter.builder((DataHolder)flexmarkOptions).htmlNodeRendererFactory(options -> new HtmlNodeRenderer(){

            public Set<HtmlNodeRendererHandler<?>> getHtmlNodeRendererHandlers() {
                return Set.of(new HtmlNodeRendererHandler("tt", Element.class, (arg_0, arg_1, arg_2) -> JavaDoc2MarkdownConverter.access$1(JavaDoc2MarkdownConverter.this, arg_0, arg_1, arg_2)), new HtmlNodeRendererHandler("dfn", Element.class, (arg_0, arg_1, arg_2) -> JavaDoc2MarkdownConverter.access$2(JavaDoc2MarkdownConverter.this, arg_0, arg_1, arg_2)), new HtmlNodeRendererHandler("dl", Element.class, (arg_0, arg_1, arg_2) -> JavaDoc2MarkdownConverter.access$3(JavaDoc2MarkdownConverter.this, arg_0, arg_1, arg_2)));
            }
        }).build();
        return converter;
    }

    @Override
    public String convert(String html) {
        Document document = Jsoup.parse((String)html);
        this.sanitize(document);
        StringBuilder markdown = new StringBuilder();
        JavaLanguageServerPlugin.logInfo("Converting html to markdown");
        this.converter.convert((Node)document, (Appendable)markdown, -1);
        return this.fixSnippet(markdown.toString());
    }

    private void sanitize(Document document) {
        document.select("a[name]:not([href]), a[href^='eclipse-javadoc:'], a[href^='#']").forEach(anchor -> {
            Node node = anchor.unwrap();
        });
        document.select("table").forEach(TableHelper::normalizeTableHeaders);
        JavaDoc2MarkdownConverter.separateConsecutiveCodeTags(document);
    }

    private static void separateConsecutiveCodeTags(Document document) {
        Elements codeElements = document.select("tt, code");
        for (Element code : codeElements) {
            Node nextNode;
            Element nextSibling = code.nextElementSibling();
            if (nextSibling == null || !JavaDoc2MarkdownConverter.isCodeTag(nextSibling.tagName()) || (nextNode = code.nextSibling()) != nextSibling) continue;
            code.after((Node)new TextNode(" "));
        }
    }

    private static boolean isCodeTag(String tagName) {
        return "tt".equals(tagName) || "code".equals(tagName);
    }

    private void processTt(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        String text = element.ownText();
        BasedSequence basedText = BasedSequence.of((CharSequence)text);
        int backTickCount = JavaDoc2MarkdownConverter.getMaxRepeatedChars((CharSequence)basedText, '`', 1);
        CharSequence backTicks = RepeatedSequence.repeatOf((CharSequence)"`", (int)backTickCount);
        context.inlineCode(() -> context.processTextNodes((Node)element, false, backTicks));
    }

    private void processDfn(Element node, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        String text = node.text();
        if (text.isBlank()) {
            out.append((CharSequence)text);
            return;
        }
        ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append((CharSequence)"_")).append((CharSequence)text)).append((CharSequence)"_");
    }

    private void processDl(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        Node item;
        context.pushState((Node)element);
        boolean lastWasDefinition = true;
        boolean firstItem = true;
        while ((item = context.next()) != null) {
            switch (item.nodeName().toLowerCase()) {
                case "dt": {
                    ((HtmlMarkdownWriter)out.blankLineIf(lastWasDefinition)).lineIf(!firstItem);
                    context.processTextNodes(item, false);
                    out.lineWithTrailingSpaces(2);
                    lastWasDefinition = false;
                    firstItem = false;
                    break;
                }
                case "dd": {
                    this.handleDefinition((Element)item, context, out);
                    lastWasDefinition = true;
                    firstItem = false;
                    break;
                }
            }
        }
        context.popState((LineAppendable)out);
    }

    private void handleDefinition(Element item, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.pushState((Node)item);
        int options = out.getOptions();
        Elements children = item.children();
        boolean firstIsPara = false;
        if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("p")) {
            out.blankLine();
            firstIsPara = true;
        }
        int count = this.myHtmlConverterOptions.listContentIndent ? this.myHtmlConverterOptions.definitionMarkerSpaces + 1 : 4;
        CharSequence childPrefix = RepeatedSequence.repeatOf((CharSequence)" ", (int)count);
        out.append(' ', this.myHtmlConverterOptions.definitionMarkerSpaces);
        out.pushPrefix();
        out.addPrefix(childPrefix, true);
        out.setOptions(options);
        if (firstIsPara) {
            context.renderChildren((Node)item, true, null);
        } else {
            context.processTextNodes((Node)item, false);
        }
        out.lineWithTrailingSpaces(2);
        out.popPrefix();
        context.popState((LineAppendable)out);
    }

    private static int getMaxRepeatedChars(CharSequence text, char ch, int min) {
        int maxCount = 0;
        int currentCount = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == ch) {
                if (++currentCount > maxCount) {
                    maxCount = currentCount;
                }
            } else {
                currentCount = 0;
            }
            ++i;
        }
        return maxCount > 0 ? maxCount + 1 : min;
    }

    private String fixSnippet(String value) {
        if (value.contains("SNIPPET")) {
            StringBuilder builder = new StringBuilder();
            value.lines().forEach(line -> {
                if (((String)line).contains("SNIPPET") && ((String)(line = ((String)line).stripLeading())).startsWith("SNIPPET")) {
                    line = ((String)line).replaceFirst("SNIPPET", "");
                    if (!((String)(line = JavaDoc2MarkdownConverter.replaceLeadingSpaces((String)line))).endsWith(DOUBLE_SPACE)) {
                        line = (String)line + DOUBLE_SPACE;
                    }
                }
                builder.append((String)line);
                builder.append(LINEBREAK);
            });
            value = builder.toString();
        }
        return value;
    }

    private static String replaceLeadingSpaces(String str) {
        int i = 0;
        while (str.length() > i + 1 && str.charAt(i) == ' ') {
            str = str.replaceFirst(" ", MARKDOWN_SPACE);
            i += MARKDOWN_SPACE.length();
        }
        return str;
    }

    static /* synthetic */ void access$1(JavaDoc2MarkdownConverter javaDoc2MarkdownConverter, Element element, HtmlNodeConverterContext htmlNodeConverterContext, HtmlMarkdownWriter htmlMarkdownWriter) {
        javaDoc2MarkdownConverter.processTt(element, htmlNodeConverterContext, htmlMarkdownWriter);
    }

    static /* synthetic */ void access$2(JavaDoc2MarkdownConverter javaDoc2MarkdownConverter, Element element, HtmlNodeConverterContext htmlNodeConverterContext, HtmlMarkdownWriter htmlMarkdownWriter) {
        javaDoc2MarkdownConverter.processDfn(element, htmlNodeConverterContext, htmlMarkdownWriter);
    }

    static /* synthetic */ void access$3(JavaDoc2MarkdownConverter javaDoc2MarkdownConverter, Element element, HtmlNodeConverterContext htmlNodeConverterContext, HtmlMarkdownWriter htmlMarkdownWriter) {
        javaDoc2MarkdownConverter.processDl(element, htmlNodeConverterContext, htmlMarkdownWriter);
    }
}

