/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jface.text.IRegion;

public class ImplementationCollector<T> {
    private static final String JavaElementImplementationHyperlink_search_implementors = "Searching for implementors...";
    private static final String JavaElementImplementationHyperlink_search_method_implementors = "Searching for implementors of ''{0}''...";
    private final IRegion region;
    private final IJavaElement javaElement;
    private ResultMapper<T> mapper;
    private ITypeRoot typeRoot;

    public ImplementationCollector(ITypeRoot typeRoot, IRegion region, IJavaElement javaElement, ResultMapper<T> mapper) {
        Assert.isNotNull((Object)typeRoot);
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)javaElement);
        Assert.isNotNull(mapper);
        Assert.isTrue((javaElement instanceof IType || javaElement instanceof IMethod ? 1 : 0) != 0);
        this.typeRoot = typeRoot;
        this.region = region;
        this.javaElement = javaElement;
        this.mapper = mapper;
    }

    public List<T> findImplementations(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(JavaElementImplementationHyperlink_search_implementors);
        List<T> implementations = null;
        if (this.javaElement instanceof IMethod) {
            implementations = this.findMethodImplementations(monitor);
        } else if (this.javaElement instanceof IType) {
            implementations = this.findTypeImplementations(monitor);
        }
        return implementations == null ? Collections.emptyList() : Collections.unmodifiableList(implementations);
    }

    private List<T> findTypeImplementations(IProgressMonitor monitor) throws JavaModelException {
        IType type = (IType)this.javaElement;
        List results = null;
        try {
            String typeLabel = JavaElementLabelsCore.getElementLabel((IJavaElement)type, (long)2298807424L);
            monitor.beginTask(Messages.format(JavaElementImplementationHyperlink_search_method_implementors, typeLabel), 10);
            IType[] allTypes = type.newTypeHierarchy(monitor).getAllSubtypes(type);
            results = Arrays.stream(allTypes).map(el -> this.mapper.convert((IJavaElement)el, 0, 0)).filter(Objects::nonNull).collect(Collectors.toList());
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
        return results;
    }

    private List<T> findMethodImplementations(IProgressMonitor monitor) throws CoreException {
        IType receiverType;
        IMethod method = (IMethod)this.javaElement;
        try {
            if (ImplementationCollector.cannotBeOverriddenMethod(method)) {
                return null;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Find method implementations failure ", e);
            return null;
        }
        CompilationUnit ast = CoreASTProvider.getInstance().getAST(this.typeRoot, CoreASTProvider.WAIT_YES, monitor);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, (int)this.region.getOffset(), (int)this.region.getLength());
        ITypeBinding parentTypeBinding = null;
        if (node instanceof SimpleName) {
            ASTNode parent = node.getParent();
            if (parent instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)parent;
                Expression expression = methodInvocation.getExpression();
                parentTypeBinding = expression == null ? Bindings.getBindingOfParentType((ASTNode)node) : expression.resolveTypeBinding();
            } else {
                if (parent instanceof SuperMethodInvocation) {
                    return Collections.singletonList(this.mapper.convert((IJavaElement)method, 0, 0));
                }
                if (parent instanceof MethodDeclaration) {
                    parentTypeBinding = Bindings.getBindingOfParentType((ASTNode)node);
                }
            }
        }
        if ((receiverType = ImplementationCollector.getType(parentTypeBinding)) == null) {
            return null;
        }
        final ArrayList results = new ArrayList();
        try {
            IJavaSearchScope hierarchyScope;
            String methodLabel = JavaElementLabelsCore.getElementLabel((IJavaElement)method, (long)2298807424L);
            monitor.beginTask(Messages.format(JavaElementImplementationHyperlink_search_method_implementors, methodLabel), 10);
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    Object result;
                    IMethod methodFound;
                    Object element;
                    if (match.getAccuracy() == 0 && (element = match.getElement()) instanceof IMethod && !JdtFlags.isAbstract((IMember)(methodFound = (IMethod)element)) && (result = ImplementationCollector.this.mapper.convert((IJavaElement)methodFound, match.getOffset(), match.getLength())) != null) {
                        results.add(result);
                    }
                }
            };
            if (receiverType.isInterface()) {
                hierarchyScope = SearchEngine.createHierarchyScope((IType)method.getDeclaringType());
            } else if (ImplementationCollector.isFullHierarchyNeeded((IProgressMonitor)new SubProgressMonitor(monitor, 3), method, receiverType)) {
                hierarchyScope = SearchEngine.createHierarchyScope((IType)receiverType);
            } else {
                boolean isMethodAbstract = JdtFlags.isAbstract((IMember)method);
                hierarchyScope = SearchEngine.createStrictHierarchyScope(null, (IType)receiverType, (boolean)true, (boolean)isMethodAbstract, null);
            }
            int limitTo = 48;
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)method, (int)limitTo);
            Assert.isNotNull((Object)pattern);
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            SearchEngine engine = new SearchEngine();
            engine.search(pattern, participants, hierarchyScope, requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
        return results;
    }

    private static IType getType(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isTypeVariable()) {
            ITypeBinding[] typeBounds = typeBinding.getTypeBounds();
            if (typeBounds.length > 0) {
                typeBinding = typeBounds[0].getTypeDeclaration();
            } else {
                return null;
            }
        }
        return (IType)typeBinding.getJavaElement();
    }

    private static boolean cannotBeOverriddenMethod(IMethod method) throws JavaModelException {
        return JdtFlags.isPrivate((IMember)method) || JdtFlags.isFinal((IMember)method) || JdtFlags.isStatic((IMember)method) || method.isConstructor() || JdtFlags.isFinal((IMember)((IMember)method.getParent()));
    }

    private static boolean isFullHierarchyNeeded(IProgressMonitor monitor, IMethod method, IType receiverType) throws JavaModelException {
        ITypeHierarchy superTypeHierarchy = receiverType.newSupertypeHierarchy(monitor);
        MethodOverrideTester methodOverrideTester = new MethodOverrideTester(receiverType, superTypeHierarchy);
        return methodOverrideTester.findOverriddenMethodInType(receiverType, method) == null;
    }

    public static interface ResultMapper<T> {
        public T convert(IJavaElement var1, int var2, int var3);
    }
}

