/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.AnnotationInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.MemberElementInfo;
import org.eclipse.jdt.internal.core.ModuleDescriptionInfo;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaElementDeltaBuilder {
    IJavaElement javaElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map annotationInfos;
    Map oldPositions;
    Map newPositions;
    public JavaElementDelta delta = null;
    HashSet added;
    HashSet removed;

    public JavaElementDeltaBuilder(IJavaElement javaElement) {
        this.javaElement = javaElement;
        this.initialize();
        this.recordElementInfo(javaElement, (JavaModel)this.javaElement.getJavaModel(), 0);
    }

    public JavaElementDeltaBuilder(IJavaElement javaElement, int maxDepth) {
        this.javaElement = javaElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(javaElement, (JavaModel)this.javaElement.getJavaModel(), 0);
    }

    private void added(IJavaElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public void buildDeltas() {
        this.delta = new JavaElementDelta(this.javaElement);
        if (this.javaElement.getElementType() >= 5) {
            this.delta.fineGrained();
        }
        this.recordNewPositions(this.javaElement, 0);
        this.findAdditions(this.javaElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.javaElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private boolean equals(char[][][] first, char[][][] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (CharOperation.equals((char[][])first[i], (char[][])second[i])) continue;
            return false;
        }
        return true;
    }

    private void findAdditions(IJavaElement newElement, int depth) {
        IJavaElement[] children;
        JavaElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        JavaElementInfo newInfo = null;
        try {
            newInfo = (JavaElementInfo)((JavaElement)newElement).getElementInfo();
        }
        catch (JavaModelException npe) {
            return;
        }
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void findChangesInPositioning(IJavaElement element, int depth) {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.changed(element, 256);
        }
        if (element instanceof IParent) {
            JavaElementInfo info = null;
            try {
                info = (JavaElementInfo)((JavaElement)element).getElementInfo();
            }
            catch (JavaModelException npe) {
                return;
            }
            IJavaElement[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findAnnotationChanges(IAnnotation[] oldAnnotations, IAnnotation[] newAnnotations, IJavaElement parent) {
        ArrayList<JavaElementDelta> annotationDeltas = null;
        IAnnotation[] iAnnotationArray = newAnnotations;
        int n = newAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation newAnnotation = iAnnotationArray[n2];
            Object oldInfo = this.annotationInfos.remove(newAnnotation);
            if (oldInfo == null) {
                JavaElementDelta annotationDelta = new JavaElementDelta(newAnnotation);
                annotationDelta.added();
                if (annotationDeltas == null) {
                    annotationDeltas = new ArrayList<JavaElementDelta>();
                }
                annotationDeltas.add(annotationDelta);
            } else {
                AnnotationInfo newInfo = null;
                try {
                    newInfo = (AnnotationInfo)((JavaElement)((Object)newAnnotation)).getElementInfo();
                }
                catch (JavaModelException npe) {
                    return;
                }
                if (!Util.equalArraysOrNull(((AnnotationInfo)oldInfo).members, newInfo.members)) {
                    JavaElementDelta annotationDelta = new JavaElementDelta(newAnnotation);
                    annotationDelta.changed(1);
                    if (annotationDeltas == null) {
                        annotationDeltas = new ArrayList();
                    }
                    annotationDeltas.add(annotationDelta);
                }
            }
            ++n2;
        }
        iAnnotationArray = oldAnnotations;
        n = oldAnnotations.length;
        n2 = 0;
        while (n2 < n) {
            IAnnotation oldAnnotation = iAnnotationArray[n2];
            if (this.annotationInfos.remove(oldAnnotation) != null) {
                JavaElementDelta annotationDelta = new JavaElementDelta(oldAnnotation);
                annotationDelta.removed();
                if (annotationDeltas == null) {
                    annotationDeltas = new ArrayList();
                }
                annotationDeltas.add(annotationDelta);
            }
            ++n2;
        }
        if (annotationDeltas == null) {
            return;
        }
        int size = annotationDeltas.size();
        if (size > 0) {
            JavaElementDelta parentDelta = this.delta.changed(parent, 0x400000);
            parentDelta.annotationDeltas = annotationDeltas.toArray(new IJavaElementDelta[size]);
        }
    }

    private void findContentChange(JavaElementInfo oldInfo, JavaElementInfo newInfo, IJavaElement newElement) {
        if (oldInfo instanceof MemberElementInfo && newInfo instanceof MemberElementInfo) {
            if (((MemberElementInfo)oldInfo).getModifiers() != ((MemberElementInfo)newInfo).getModifiers()) {
                this.delta.changed(newElement, 2);
            }
            if (oldInfo instanceof AnnotatableInfo && newInfo instanceof AnnotatableInfo) {
                this.findAnnotationChanges(((AnnotatableInfo)oldInfo).annotations, ((AnnotatableInfo)newInfo).annotations, newElement);
            }
            if (oldInfo instanceof SourceMethodElementInfo && newInfo instanceof SourceMethodElementInfo) {
                SourceMethodElementInfo oldSourceMethodInfo = (SourceMethodElementInfo)oldInfo;
                SourceMethodElementInfo newSourceMethodInfo = (SourceMethodElementInfo)newInfo;
                if (!(CharOperation.equals((char[])oldSourceMethodInfo.getReturnTypeName(), (char[])newSourceMethodInfo.getReturnTypeName()) && CharOperation.equals((char[][])oldSourceMethodInfo.getTypeParameterNames(), (char[][])newSourceMethodInfo.getTypeParameterNames()) && this.equals(oldSourceMethodInfo.getTypeParameterBounds(), newSourceMethodInfo.getTypeParameterBounds()))) {
                    this.delta.changed(newElement, 1);
                }
            } else if (oldInfo instanceof SourceFieldElementInfo && newInfo instanceof SourceFieldElementInfo) {
                if (!CharOperation.equals((char[])((SourceFieldElementInfo)oldInfo).getTypeName(), (char[])((SourceFieldElementInfo)newInfo).getTypeName())) {
                    this.delta.changed(newElement, 1);
                }
            } else if (oldInfo instanceof SourceTypeElementInfo && newInfo instanceof SourceTypeElementInfo) {
                SourceTypeElementInfo oldSourceTypeInfo = (SourceTypeElementInfo)oldInfo;
                SourceTypeElementInfo newSourceTypeInfo = (SourceTypeElementInfo)newInfo;
                if (!CharOperation.equals((char[])oldSourceTypeInfo.getSuperclassName(), (char[])newSourceTypeInfo.getSuperclassName()) || !CharOperation.equals((char[][])oldSourceTypeInfo.getInterfaceNames(), (char[][])newSourceTypeInfo.getInterfaceNames())) {
                    this.delta.changed(newElement, 2048);
                }
                if (!CharOperation.equals((char[][])oldSourceTypeInfo.getTypeParameterNames(), (char[][])newSourceTypeInfo.getTypeParameterNames()) || !this.equals(oldSourceTypeInfo.getTypeParameterBounds(), newSourceTypeInfo.getTypeParameterBounds())) {
                    this.delta.changed(newElement, 1);
                }
                this.findCategoryChange(oldSourceTypeInfo.categories, newSourceTypeInfo.categories);
            } else if (oldInfo instanceof ModuleDescriptionInfo && newInfo instanceof ModuleDescriptionInfo) {
                ModuleDescriptionInfo oldSourceModuleInfo = (ModuleDescriptionInfo)oldInfo;
                ModuleDescriptionInfo newSourceModuleInfo = (ModuleDescriptionInfo)newInfo;
                this.findCategoryChange(oldSourceModuleInfo.getCategories(), newSourceModuleInfo.getCategories());
            }
        }
    }

    private void findCategoryChange(Map<IJavaElement, String[]> oldCategoriesMap, Map<IJavaElement, String[]> newCategoriesMap) {
        block5: {
            block4: {
                Set<IJavaElement> elements;
                if (oldCategoriesMap == null) break block4;
                if (newCategoriesMap != null) {
                    elements = new HashSet<IJavaElement>(oldCategoriesMap.keySet());
                    elements.addAll(newCategoriesMap.keySet());
                } else {
                    elements = oldCategoriesMap.keySet();
                }
                for (IJavaElement element : elements) {
                    Object[] newCategories;
                    Object[] oldCategories = oldCategoriesMap.get(element);
                    Object[] objectArray = newCategories = newCategoriesMap == null ? null : newCategoriesMap.get(element);
                    if (Util.equalArraysOrNull(oldCategories, newCategories)) continue;
                    this.delta.changed(element, 0x100000);
                }
                break block5;
            }
            if (newCategoriesMap == null) break block5;
            for (IJavaElement element : newCategoriesMap.keySet()) {
                this.delta.changed(element, 0x100000);
            }
        }
    }

    private void findDeletions() {
        for (IJavaElement element : this.infos.keySet()) {
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private JavaElementInfo getElementInfo(IJavaElement element) {
        return (JavaElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(IJavaElement element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(IJavaElement element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.oldPositions.put(this.javaElement, new ListItem(null, null));
        this.newPositions.put(this.javaElement, new ListItem(null, null));
        this.added = new HashSet(5);
        this.removed = new HashSet(5);
    }

    private void insertPositions(IJavaElement[] elements, boolean isNew) {
        int length = elements.length;
        IJavaElement previous = null;
        IJavaElement current = null;
        IJavaElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IJavaElement iJavaElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.newPositions.put(current, new ListItem(previous, next));
            } else {
                this.oldPositions.put(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isPositionedCorrectly(IJavaElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IJavaElement oldPrevious = oldListItem.previous;
        IJavaElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private void recordElementInfo(IJavaElement element, JavaModel model, int depth) {
        int n;
        IJavaElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        JavaElementInfo info = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(element);
        if (info == null) {
            return;
        }
        this.infos.put(element, info);
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            IJavaElement[] iJavaElementArray = children;
            n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.recordElementInfo(child, model, depth + 1);
                ++n2;
            }
        }
        IAnnotation[] annotations = null;
        if (info instanceof AnnotatableInfo) {
            annotations = ((AnnotatableInfo)info).annotations;
        }
        if (annotations != null) {
            if (this.annotationInfos == null) {
                this.annotationInfos = new HashMap();
            }
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            IAnnotation[] iAnnotationArray = annotations;
            int n3 = annotations.length;
            n = 0;
            while (n < n3) {
                IAnnotation annotation = iAnnotationArray[n];
                this.annotationInfos.put(annotation, manager.getInfo(annotation));
                ++n;
            }
        }
    }

    private void recordNewPositions(IJavaElement newElement, int depth) {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            JavaElementInfo info = null;
            try {
                info = (JavaElementInfo)((JavaElement)newElement).getElementInfo();
            }
            catch (JavaModelException npe) {
                return;
            }
            IJavaElement[] children = info.getChildren();
            if (children != null) {
                this.insertPositions(children, true);
                IJavaElement[] iJavaElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    this.recordNewPositions(child, depth + 1);
                    ++n2;
                }
            }
        }
    }

    private void removed(IJavaElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(IJavaElement element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Built delta:\n");
        buffer.append(this.delta == null ? "<null>" : this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(JavaElementDelta elementDelta) {
        if (elementDelta.getKind() == 2) {
            elementDelta.clearAffectedChildren();
        } else {
            IJavaElementDelta[] children;
            IJavaElementDelta[] iJavaElementDeltaArray = children = elementDelta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.trimDelta((JavaElementDelta)child);
                ++n2;
            }
        }
    }

    static class ListItem {
        public IJavaElement previous;
        public IJavaElement next;

        public ListItem(IJavaElement previous, IJavaElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

