/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.javac.JavacCompiler;

public class ProceedOnErrorTransTypes
extends TransTypes {
    private boolean needsProceedOnError;
    private Context context;

    public static void preRegister(Context context) {
        context.put(transTypesKey, c -> new ProceedOnErrorTransTypes(c));
    }

    protected ProceedOnErrorTransTypes(Context context) {
        super(context);
        this.context = context;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl def) {
        this.needsProceedOnError = this.hasErrors(def);
        super.visitClassDef(def);
        this.needsProceedOnError = false;
    }

    private boolean hasErrors(JCTree.JCClassDecl def) {
        return this.context.get(JavacCompiler.FILES_WITH_ERRORS_KEY).contains(def.sym.sourcefile);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        if (!this.isValid(tree) || tree.args.stream().anyMatch(Predicate.not(this::isValid))) {
            return;
        }
        Symbol meth = TreeInfo.symbol(tree.meth);
        if (!(meth.baseSymbol() instanceof Symbol.MethodSymbol)) {
            return;
        }
        super.visitApply(tree);
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        if (!this.isValid(tree.lhs) || !this.isValid(tree.rhs)) {
            return;
        }
        super.visitAssign(tree);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        if (!this.isValid(tree) || !this.isValid(tree.expr)) {
            return;
        }
        super.visitTypeCast(tree);
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        if (!this.isValid(tree)) {
            return;
        }
        super.visitParens(tree);
    }

    private boolean isValid(JCTree tree) {
        return tree != null && tree.type != null && !tree.type.isErroneous();
    }
}

