/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.events.task.internal;

import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.PluginIdentifier;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTaskDescriptor;
import org.gradle.tooling.model.internal.Exceptions;

public final class DefaultTaskOperationDescriptor
extends DefaultOperationDescriptor
implements TaskOperationDescriptor {
    private static final String DEPENDENCIES_METHOD = TaskOperationDescriptor.class.getSimpleName() + ".getDependencies()";
    private static final String ORIGIN_PLUGIN_METHOD = TaskOperationDescriptor.class.getSimpleName() + ".getOriginPlugin()";
    private final String taskPath;
    private final Supplier<Set<OperationDescriptor>> dependencies;
    private final Supplier<PluginIdentifier> originPlugin;

    public DefaultTaskOperationDescriptor(InternalTaskDescriptor descriptor, OperationDescriptor parent, String taskPath) {
        this(descriptor, parent, taskPath, DefaultTaskOperationDescriptor.unsupportedDependencies(), DefaultTaskOperationDescriptor.unsupportedOriginPlugin());
    }

    public DefaultTaskOperationDescriptor(InternalTaskDescriptor descriptor, OperationDescriptor parent, String taskPath, Set<OperationDescriptor> dependencies, @Nullable PluginIdentifier originPlugin) {
        this(descriptor, parent, taskPath, Suppliers.ofInstance(dependencies), Suppliers.ofInstance(originPlugin));
    }

    private DefaultTaskOperationDescriptor(InternalTaskDescriptor descriptor, OperationDescriptor parent, String taskPath, Supplier<Set<OperationDescriptor>> dependencies, Supplier<PluginIdentifier> originPlugin) {
        super(descriptor, parent);
        this.taskPath = taskPath;
        this.dependencies = dependencies;
        this.originPlugin = originPlugin;
    }

    @Override
    public String getTaskPath() {
        return this.taskPath;
    }

    @Override
    public Set<? extends OperationDescriptor> getDependencies() {
        return this.dependencies.get();
    }

    @Override
    public @Nullable PluginIdentifier getOriginPlugin() {
        return this.originPlugin.get();
    }

    private static Supplier<PluginIdentifier> unsupportedOriginPlugin() {
        return DefaultTaskOperationDescriptor.unsupportedMethodExceptionThrowingSupplier(ORIGIN_PLUGIN_METHOD);
    }

    private static Supplier<Set<OperationDescriptor>> unsupportedDependencies() {
        return DefaultTaskOperationDescriptor.unsupportedMethodExceptionThrowingSupplier(DEPENDENCIES_METHOD);
    }

    private static <T> Supplier<T> unsupportedMethodExceptionThrowingSupplier(final String method) {
        return new Supplier<T>(){

            @Override
            public T get() {
                throw Exceptions.unsupportedMethod(method);
            }
        };
    }
}

