/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.inject.internal.Annotations;
import org.apache.felix.scr.impl.inject.internal.ClassUtils;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class ValueUtils {
    public static final ValueType[] EMPTY_VALUE_TYPES = new ValueType[0];

    public static ValueType getValueType(Class<?> typeClass) {
        if (typeClass == ClassUtils.COMPONENT_CONTEXT_CLASS) {
            return ValueType.componentContext;
        }
        if (typeClass == ClassUtils.BUNDLE_CONTEXT_CLASS) {
            return ValueType.bundleContext;
        }
        if (typeClass == ClassUtils.MAP_CLASS) {
            return ValueType.config_map;
        }
        if (typeClass.isAnnotation()) {
            return ValueType.config_annotation;
        }
        return ValueType.ignore;
    }

    public static ValueType getReferenceValueType(Class<?> componentClass, ReferenceMetadata metadata, Class<?> typeClass, Field field, ComponentLogger logger) {
        Class<?> referenceType = ClassUtils.getClassFromComponentClassLoader(componentClass, metadata.getInterface(), logger);
        ValueType valueType = ValueType.ignore;
        if (!metadata.isMultiple()) {
            if (typeClass.isAssignableFrom(referenceType)) {
                valueType = ValueType.ref_serviceType;
            } else if (typeClass == ClassUtils.SERVICE_REFERENCE_CLASS) {
                valueType = ValueType.ref_serviceReference;
            } else if (typeClass == ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) {
                valueType = ValueType.ref_serviceObjects;
            } else if (typeClass == ClassUtils.MAP_CLASS) {
                valueType = ValueType.ref_map;
            } else if (typeClass == ClassUtils.MAP_ENTRY_CLASS) {
                valueType = ValueType.ref_tuple;
            } else {
                if (typeClass.getName().equals("org.osgi.service.log.Logger") && metadata.getInterface().equals("org.osgi.service.log.LoggerFactory")) {
                    return ValueType.ref_logger;
                }
                if (typeClass.getName().equals("org.osgi.service.log.FormatterLogger") && metadata.getInterface().equals("org.osgi.service.log.LoggerFactory")) {
                    return ValueType.ref_formatterLogger;
                }
                if (typeClass == ClassUtils.OPTIONAL_CLASS) {
                    valueType = ValueType.ref_optional;
                } else {
                    if (field != null) {
                        logger.log(InternalLogger.Level.ERROR, "Field {0} in class {1} has unsupported type {2}", null, metadata.getField(), componentClass, typeClass.getName());
                    } else {
                        logger.log(InternalLogger.Level.ERROR, "Constructor argument {0} in class {1} has unsupported type {2}", null, metadata.getParameterIndex(), componentClass, typeClass.getName());
                    }
                    valueType = ValueType.ignore;
                }
            }
            if (field != null && !metadata.isStatic() && !Modifier.isVolatile(field.getModifiers())) {
                logger.log(InternalLogger.Level.ERROR, "Field {0} in class {1} must be declared volatile to handle a dynamic reference", null, metadata.getField(), componentClass);
                valueType = ValueType.ignore;
            }
            if (field != null && Modifier.isFinal(field.getModifiers())) {
                logger.log(InternalLogger.Level.ERROR, "Field {0} in class {1} must not be declared as final", null, metadata.getField(), componentClass);
                valueType = ValueType.ignore;
            }
        } else {
            String colType = metadata.getCollectionType();
            valueType = ValueUtils.getCollectionValueType(colType);
            if (!ClassUtils.COLLECTION_CLASS.isAssignableFrom(typeClass)) {
                if (field != null) {
                    logger.log(InternalLogger.Level.ERROR, "Field {0} in class {1} has unsupported type {2}", null, metadata.getField(), componentClass, typeClass.getName());
                } else {
                    logger.log(InternalLogger.Level.ERROR, "Constructor argument {0} in class {1} has unsupported type {2}", null, metadata.getParameterIndex(), componentClass, typeClass.getName());
                }
                valueType = ValueType.ignore;
            }
            if (metadata.isReplace() && field != null) {
                if (!metadata.isStatic() && !Modifier.isVolatile(field.getModifiers())) {
                    logger.log(InternalLogger.Level.ERROR, "Field {0} in class {1} must be declared volatile to handle a dynamic reference", null, metadata.getField(), componentClass);
                    valueType = ValueType.ignore;
                }
                if (typeClass != ClassUtils.LIST_CLASS && typeClass != ClassUtils.COLLECTION_CLASS) {
                    logger.log(InternalLogger.Level.ERROR, "Field {0} in class {1} has unsupported type {2}. It must be one of java.util.Collection or java.util.List.", null, metadata.getField(), componentClass, typeClass.getName());
                    valueType = ValueType.ignore;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    logger.log(InternalLogger.Level.ERROR, "Field {0} in class {1} must not be declared as final", null, metadata.getField(), componentClass);
                    valueType = ValueType.ignore;
                }
            }
        }
        if (field != null && metadata.isStatic() && !metadata.isReplace()) {
            logger.log(InternalLogger.Level.ERROR, "Update strategy for field {0} in class {1} only allowed for non static field references.", null, metadata.getField(), componentClass);
            valueType = ValueType.ignore;
        }
        return valueType;
    }

    public static ValueType getCollectionValueType(String colType) {
        if (colType == null) {
            return ValueType.ref_serviceType;
        }
        switch (colType) {
            case "service": {
                return ValueType.ref_serviceType;
            }
            case "reference": {
                return ValueType.ref_serviceReference;
            }
            case "serviceobjects": {
                return ValueType.ref_serviceObjects;
            }
            case "properties": {
                return ValueType.ref_map;
            }
            case "tuple": {
                return ValueType.ref_tuple;
            }
        }
        return ValueType.ignore;
    }

    public static Object getValue(String componentType, ValueType type, Class<?> targetType, ScrComponentContext componentContext, RefPair<?, ?> refPair, ReferenceMetadata referenceMetaData) {
        switch (type.ordinal()) {
            case 0: {
                return null;
            }
            case 1: {
                return componentContext;
            }
            case 2: {
                return componentContext.getBundleContext();
            }
            case 3: {
                return componentContext.getProperties();
            }
            case 4: {
                return Annotations.toObject(targetType, (Map)((Object)componentContext.getProperties()), componentContext.getBundleContext().getBundle(), componentContext.getComponentMetadata().isConfigureWithInterfaces());
            }
            case 9: {
                return refPair.getServiceObject(componentContext);
            }
            case 7: {
                return refPair.getRef();
            }
            case 8: {
                return componentContext.getComponentServiceObjectsHelper().getServiceObjects(refPair.getRef());
            }
            case 10: {
                return new ReadOnlyDictionary(refPair.getRef());
            }
            case 11: {
                ReadOnlyDictionary tupleKey = new ReadOnlyDictionary(refPair.getRef());
                Object tupleValue = refPair.getServiceObject(componentContext);
                return new MapEntryImpl(tupleKey, tupleValue, refPair.getRef());
            }
            case 5: 
            case 6: {
                return ValueUtils.getLogger(componentType, targetType, componentContext, refPair);
            }
            case 12: {
                String stringType = referenceMetaData == null ? "service" : referenceMetaData.getCollectionType();
                ValueType optionalValueType = ValueUtils.getCollectionValueType(stringType);
                Object value = ValueUtils.getValue(componentType, optionalValueType, targetType, componentContext, refPair, referenceMetaData);
                return Optional.ofNullable(value);
            }
        }
        return null;
    }

    private static Object getLogger(String componentType, Class<?> targetType, ScrComponentContext componentContext, RefPair<?, ?> refPair) {
        Object factory = refPair.getServiceObject(componentContext);
        if (factory != null) {
            Exception error = null;
            try {
                Method m = factory.getClass().getMethod("getLogger", Bundle.class, String.class, Class.class);
                m.setAccessible(true);
                return m.invoke(factory, componentContext.getBundleContext().getBundle(), componentType, targetType);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                error = e;
                componentContext.getLogger().log(InternalLogger.Level.ERROR, "Unexpected error while trying to get logger.", null, error);
            }
        }
        return null;
    }

    public static enum ValueType {
        ignore,
        componentContext,
        bundleContext,
        config_map,
        config_annotation,
        ref_logger,
        ref_formatterLogger,
        ref_serviceReference,
        ref_serviceObjects,
        ref_serviceType,
        ref_map,
        ref_tuple,
        ref_optional;

    }

    private static final class MapEntryImpl
    implements Map.Entry,
    Comparable<Map.Entry<?, ?>> {
        private final Object key;
        private final Object value;
        private final ServiceReference<?> ref;

        public MapEntryImpl(Object key, Object value, ServiceReference<?> ref) {
            this.key = key;
            this.value = value;
            this.ref = ref;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Map.Entry<?, ?> o) {
            if (o == null) {
                return 1;
            }
            if (o instanceof MapEntryImpl) {
                MapEntryImpl other = (MapEntryImpl)o;
                return this.ref.compareTo(other.ref);
            }
            return new Integer(this.hashCode()).compareTo(o.hashCode());
        }
    }
}

