/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class Cookie
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5433071011125749022L;
    private static final String TSPECIALS;
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String PATH = "Path";
    private static final String SECURE = "Secure";
    private static final String HTTP_ONLY = "HttpOnly";
    private static final String EMPTY_STRING = "";
    private static final ResourceBundle lStrings;
    private final String name;
    private String value;
    private Map<String, String> attributes = null;

    public Cookie(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(Cookie.createErrorMessage("err.cookie_name_blank", new Object[0]));
        }
        if (Cookie.hasReservedCharacters(name)) {
            throw new IllegalArgumentException(Cookie.createErrorMessage("err.cookie_name_invalid", name));
        }
        this.name = name;
        this.value = value;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public void setComment(String purpose) {
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public String getComment() {
        return null;
    }

    public void setDomain(String domain) {
        this.putAttribute(DOMAIN, domain != null ? domain.toLowerCase(Locale.ENGLISH) : null);
    }

    public String getDomain() {
        return this.getAttribute(DOMAIN);
    }

    public void setMaxAge(int expiry) {
        this.putAttribute(MAX_AGE, expiry < 0 ? null : String.valueOf(expiry));
    }

    public int getMaxAge() {
        String maxAge = this.getAttribute(MAX_AGE);
        return maxAge == null ? -1 : Integer.parseInt(maxAge);
    }

    public void setPath(String uri) {
        this.putAttribute(PATH, uri);
    }

    public String getPath() {
        return this.getAttribute(PATH);
    }

    public void setSecure(boolean flag) {
        if (flag) {
            this.putAttribute(SECURE, EMPTY_STRING);
        } else {
            this.putAttribute(SECURE, null);
        }
    }

    public boolean getSecure() {
        return EMPTY_STRING.equals(this.getAttribute(SECURE));
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public int getVersion() {
        return 0;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public void setVersion(int v) {
    }

    private static boolean hasReservedCharacters(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    private static String createErrorMessage(String key, Object ... arguments) {
        String errMsg = lStrings.getString(key);
        return MessageFormat.format(errMsg, arguments);
    }

    public Object clone() {
        try {
            Cookie clone = (Cookie)super.clone();
            if (this.attributes != null) {
                clone.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                clone.attributes.putAll(this.attributes);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setHttpOnly(boolean httpOnly) {
        if (httpOnly) {
            this.putAttribute(HTTP_ONLY, EMPTY_STRING);
        } else {
            this.putAttribute(HTTP_ONLY, null);
        }
    }

    public boolean isHttpOnly() {
        return EMPTY_STRING.equals(this.getAttribute(HTTP_ONLY));
    }

    public void setAttribute(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(Cookie.createErrorMessage("err.cookie_attribute_name_blank", new Object[0]));
        }
        if (Cookie.hasReservedCharacters(name)) {
            throw new IllegalArgumentException(Cookie.createErrorMessage("err.cookie_attribute_name_invalid", name));
        }
        if (MAX_AGE.equalsIgnoreCase(name) && value != null) {
            this.setMaxAge(Integer.parseInt(value));
        } else {
            this.putAttribute(name, value);
        }
    }

    private void putAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public String getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.attributes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Cookie) {
            Cookie c = (Cookie)obj;
            return Objects.equals(this.getName(), c.getName()) && Objects.equals(this.getValue(), c.getValue()) && this.getVersion() == c.getVersion() && Objects.equals(this.getAttributes(), c.getAttributes());
        }
        return false;
    }

    public String toString() {
        return String.format("%s{%s=%s,%s}", super.toString(), this.name, this.value, this.attributes);
    }

    static {
        lStrings = ResourceBundle.getBundle(LSTRING_FILE);
        boolean enforced = Boolean.parseBoolean(System.getProperty("org.glassfish.web.rfc2109_cookie_names_enforced", "true"));
        TSPECIALS = enforced ? "/()<>@,;:\\\"[]?={} \t" : ",; ";
    }
}

