"use strict";
/*********************************************************************
 * Copyright (c) 2023 Kichwa Coders and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const cp = require("child_process");
const path = require("path");
const utils_1 = require("./utils");
const chai_1 = require("chai");
describe('attach', function () {
    let dc;
    let inferior;
    const program = path.join(utils_1.testProgramsDir, 'loopforever');
    const src = path.join(utils_1.testProgramsDir, 'loopforever.c');
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            dc = yield (0, utils_1.standardBeforeEach)();
            inferior = cp.spawn(program, ['running-from-spawn'], {
                cwd: utils_1.testProgramsDir,
            });
        });
    });
    afterEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield dc.stop();
            inferior.kill();
        });
    });
    it('can attach and hit a breakpoint', function () {
        return __awaiter(this, void 0, void 0, function* () {
            if (utils_1.isRemoteTest) {
                // attachRemote.spec.ts is the test for when isRemoteTest
                this.skip();
            }
            const attachArgs = (0, utils_1.fillDefaults)(this.test, {
                program: program,
                processId: `${inferior.pid}`,
            });
            yield dc.attachHitBreakpoint(attachArgs, { line: 25, path: src });
            (0, chai_1.expect)(yield dc.evaluate('argv[1]')).to.contain('running-from-spawn');
        });
    });
});
//# sourceMappingURL=attach.spec.js.map