"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GDBFileSystemProcessManager = void 0;
const child_process_1 = require("child_process");
const parseGdbVersionOutput_1 = require("../../util/parseGdbVersionOutput");
const util_1 = require("util");
const fs_1 = require("fs");
const path_1 = require("path");
const GDBFileSystemProcessManagerBase_1 = require("./GDBFileSystemProcessManagerBase");
class GDBFileSystemProcessManager extends GDBFileSystemProcessManagerBase_1.GDBFileSystemProcessManagerBase {
    constructor() {
        super();
        this.token = 0;
    }
    getGdbCwd(requestArgs) {
        const cwd = requestArgs.cwd ||
            (requestArgs.program && (0, fs_1.existsSync)(requestArgs.program)
                ? (0, path_1.dirname)(requestArgs.program)
                : process.cwd());
        return (0, fs_1.existsSync)(cwd) ? cwd : process.cwd();
    }
    getVersion(requestArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.gdbVersion) {
                return this.gdbVersion;
            }
            requestArgs = requestArgs || this.requestArgs;
            if (!requestArgs) {
                throw new Error(`You need to initialize first!`);
            }
            const gdbPath = requestArgs.gdb || 'gdb';
            const gdbEnvironment = this.getEnvironment(requestArgs.environment);
            const gdbCwd = this.getGdbCwd(requestArgs);
            const { stdout, stderr } = yield (0, util_1.promisify)(child_process_1.execFile)(gdbPath, ['--version'], { cwd: gdbCwd, env: gdbEnvironment });
            const gdbVersion = (0, parseGdbVersionOutput_1.parseGdbVersionOutput)(stdout);
            if (!gdbVersion) {
                throw new Error(`Failed to get version number from GDB. GDB returned:\nstdout:\n${stdout}\nstderr:\n${stderr}`);
            }
            this.gdbVersion = gdbVersion;
            return gdbVersion;
        });
    }
    start(requestArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            this.requestArgs = requestArgs;
            yield this.getVersion(requestArgs);
            const gdbPath = this.requestArgs.gdb || 'gdb';
            let gdbArgs = ['--interpreter=mi2'];
            if (requestArgs.gdbArguments) {
                gdbArgs = gdbArgs.concat(requestArgs.gdbArguments);
            }
            const gdbCwd = this.getGdbCwd(requestArgs);
            return this.spawn(gdbPath, gdbArgs, {
                cwd: gdbCwd,
                additionalEnvironment: requestArgs.environment,
            });
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            this.kill();
        });
    }
}
exports.GDBFileSystemProcessManager = GDBFileSystemProcessManager;
//# sourceMappingURL=GDBFileSystemProcessManager.js.map